/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.trace;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.example.trace.EventThread;
import com.sun.tools.example.trace.StreamRedirectThread;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;

public class Trace {
    private final VirtualMachine vm;
    private Thread errThread = null;
    private Thread outThread = null;
    private int debugTraceMode = 0;
    private boolean watchFields = false;
    private String[] excludes = new String[]{"java.*", "javax.*", "sun.*", "com.sun.*"};

    public static void main(String[] args) {
        new Trace(args);
    }

    Trace(String[] args) {
        String arg;
        int inx;
        PrintWriter writer = new PrintWriter(System.out);
        for (inx = 0; inx < args.length && (arg = args[inx]).charAt(0) == '-'; ++inx) {
            if (arg.equals("-output")) {
                try {
                    writer = new PrintWriter(new FileWriter(args[++inx]));
                }
                catch (IOException exc) {
                    System.err.println("Cannot open output file: " + args[inx] + " - " + exc);
                    System.exit(1);
                }
                continue;
            }
            if (arg.equals("-all")) {
                this.excludes = new String[0];
                continue;
            }
            if (arg.equals("-fields")) {
                this.watchFields = true;
                continue;
            }
            if (arg.equals("-dbgtrace")) {
                this.debugTraceMode = Integer.parseInt(args[++inx]);
                continue;
            }
            if (arg.equals("-help")) {
                this.usage();
                System.exit(0);
                continue;
            }
            System.err.println("No option: " + arg);
            this.usage();
            System.exit(1);
        }
        if (inx >= args.length) {
            System.err.println("<class> missing");
            this.usage();
            System.exit(1);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(args[inx]);
        ++inx;
        while (inx < args.length) {
            sb.append(' ');
            sb.append(args[inx]);
            ++inx;
        }
        this.vm = this.launchTarget(sb.toString());
        this.generateTrace(writer);
    }

    void generateTrace(PrintWriter writer) {
        this.vm.setDebugTraceMode(this.debugTraceMode);
        EventThread eventThread = new EventThread(this.vm, this.excludes, writer);
        eventThread.setEventRequests(this.watchFields);
        eventThread.start();
        this.redirectOutput();
        this.vm.resume();
        try {
            eventThread.join();
            this.errThread.join();
            this.outThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        writer.close();
    }

    VirtualMachine launchTarget(String mainArgs) {
        LaunchingConnector connector = this.findLaunchingConnector();
        Map arguments = this.connectorArguments(connector, mainArgs);
        try {
            return connector.launch(arguments);
        }
        catch (IOException exc) {
            throw new Error("Unable to launch target VM: " + exc);
        }
        catch (IllegalConnectorArgumentsException exc) {
            throw new Error("Internal error: " + exc);
        }
        catch (VMStartException exc) {
            throw new Error("Target VM failed to initialize: " + exc.getMessage());
        }
    }

    void redirectOutput() {
        Process process = this.vm.process();
        this.errThread = new StreamRedirectThread("error reader", process.getErrorStream(), System.err);
        this.outThread = new StreamRedirectThread("output reader", process.getInputStream(), System.out);
        this.errThread.start();
        this.outThread.start();
    }

    LaunchingConnector findLaunchingConnector() {
        List<Connector> connectors = Bootstrap.virtualMachineManager().allConnectors();
        for (Connector connector : connectors) {
            if (!connector.name().equals("com.sun.jdi.CommandLineLaunch")) continue;
            return (LaunchingConnector)connector;
        }
        throw new Error("No launching connector");
    }

    Map connectorArguments(LaunchingConnector connector, String mainArgs) {
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        Connector.Argument mainArg = arguments.get("main");
        if (mainArg == null) {
            throw new Error("Bad launching connector");
        }
        mainArg.setValue(mainArgs);
        if (this.watchFields) {
            Connector.Argument optionArg = arguments.get("options");
            if (optionArg == null) {
                throw new Error("Bad launching connector");
            }
            optionArg.setValue("-classic");
        }
        return arguments;
    }

    void usage() {
        System.err.println("Usage: java Trace <options> <class> <args>");
        System.err.println("<options> are:");
        System.err.println("  -output <filename>   Output trace to <filename>");
        System.err.println("  -all                 Include system classes in output");
        System.err.println("  -help                Print this help message");
        System.err.println("<class> is the program to trace");
        System.err.println("<args> are the arguments to <class>");
    }
}

