/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SourceMapper {
    private final String[] dirs;

    SourceMapper(List<String> sourcepath) {
        ArrayList<String> dirList = new ArrayList<String>();
        for (String element : sourcepath) {
            if (element.endsWith(".jar") || element.endsWith(".zip")) continue;
            dirList.add(element);
        }
        this.dirs = dirList.toArray(new String[0]);
    }

    SourceMapper(String sourcepath) {
        StringTokenizer st = new StringTokenizer(sourcepath, File.pathSeparator);
        ArrayList<String> dirList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.endsWith(".jar") || s.endsWith(".zip")) continue;
            dirList.add(s);
        }
        this.dirs = dirList.toArray(new String[0]);
    }

    String getSourcePath() {
        int i = 0;
        if (this.dirs.length < 1) {
            return "";
        }
        StringBuffer sp = new StringBuffer(this.dirs[i++]);
        while (i < this.dirs.length) {
            sp.append(File.pathSeparator);
            sp.append(this.dirs[i]);
            ++i;
        }
        return sp.toString();
    }

    File sourceFile(Location loc) {
        try {
            String filename = loc.sourceName();
            String refName = loc.declaringType().name();
            int iDot = refName.lastIndexOf(46);
            String pkgName = iDot >= 0 ? refName.substring(0, iDot + 1) : "";
            String full = pkgName.replace('.', File.separatorChar) + filename;
            for (int i = 0; i < this.dirs.length; ++i) {
                File path = new File(this.dirs[i], full);
                if (!path.exists()) continue;
                return path;
            }
            return null;
        }
        catch (AbsentInformationException e) {
            return null;
        }
    }

    BufferedReader sourceReader(Location loc) {
        File sourceFile = this.sourceFile(loc);
        if (sourceFile == null) {
            return null;
        }
        try {
            return new BufferedReader(new FileReader(sourceFile));
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

