/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.tty.AccessWatchpointSpec;
import com.sun.tools.example.debug.tty.BreakpointSpec;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.ExceptionSpec;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ModificationWatchpointSpec;
import com.sun.tools.example.debug.tty.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.tty.WatchpointSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventRequestSpecList {
    private static final int statusResolved = 1;
    private static final int statusUnresolved = 2;
    private static final int statusError = 3;
    private List<EventRequestSpec> eventRequestSpecs = Collections.synchronizedList(new ArrayList());

    EventRequestSpecList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean resolve(ClassPrepareEvent event) {
        boolean failure = false;
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            for (EventRequestSpec spec : this.eventRequestSpecs) {
                if (spec.isResolved()) continue;
                try {
                    EventRequest eventRequest = spec.resolve(event);
                    if (eventRequest == null) continue;
                    MessageOutput.println("Set deferred", spec.toString());
                }
                catch (Exception e) {
                    MessageOutput.println("Unable to set deferred", new Object[]{spec.toString(), spec.errorMessageFor(e)});
                    failure = true;
                }
            }
        }
        return !failure;
    }

    void resolveAll() {
        for (EventRequestSpec spec : this.eventRequestSpecs) {
            try {
                EventRequest eventRequest = spec.resolveEagerly();
                if (eventRequest == null) continue;
                MessageOutput.println("Set deferred", spec.toString());
            }
            catch (Exception exception) {}
        }
    }

    boolean addEagerlyResolve(EventRequestSpec spec) {
        try {
            this.eventRequestSpecs.add(spec);
            EventRequest eventRequest = spec.resolveEagerly();
            if (eventRequest != null) {
                MessageOutput.println("Set", spec.toString());
            }
            return true;
        }
        catch (Exception exc) {
            MessageOutput.println("Unable to set", new Object[]{spec.toString(), spec.errorMessageFor(exc)});
            return false;
        }
    }

    BreakpointSpec createBreakpoint(String classPattern, int line) throws ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new BreakpointSpec(refSpec, line);
    }

    BreakpointSpec createBreakpoint(String classPattern, String methodId, List<String> methodArgs) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new BreakpointSpec(refSpec, methodId, methodArgs);
    }

    EventRequestSpec createExceptionCatch(String classPattern, boolean notifyCaught, boolean notifyUncaught) throws ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ExceptionSpec(refSpec, notifyCaught, notifyUncaught);
    }

    WatchpointSpec createAccessWatchpoint(String classPattern, String fieldId) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new AccessWatchpointSpec(refSpec, fieldId);
    }

    WatchpointSpec createModificationWatchpoint(String classPattern, String fieldId) throws MalformedMemberNameException, ClassNotFoundException {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ModificationWatchpointSpec(refSpec, fieldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean delete(EventRequestSpec proto) {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            int inx = this.eventRequestSpecs.indexOf(proto);
            if (inx != -1) {
                EventRequestSpec spec = this.eventRequestSpecs.get(inx);
                spec.remove();
                this.eventRequestSpecs.remove(inx);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventRequestSpec> eventRequestSpecs() {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            return new ArrayList<EventRequestSpec>(this.eventRequestSpecs);
        }
    }
}

