/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.tty;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.tools.example.debug.tty.AmbiguousMethodException;
import com.sun.tools.example.debug.tty.Env;
import com.sun.tools.example.debug.tty.EventRequestSpec;
import com.sun.tools.example.debug.tty.LineNotFoundException;
import com.sun.tools.example.debug.tty.MalformedMemberNameException;
import com.sun.tools.example.debug.tty.MessageOutput;
import com.sun.tools.example.debug.tty.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BreakpointSpec
extends EventRequestSpec {
    String methodId;
    List<String> methodArgs;
    int lineNumber;

    BreakpointSpec(ReferenceTypeSpec refSpec, int lineNumber) {
        super(refSpec);
        this.methodId = null;
        this.methodArgs = null;
        this.lineNumber = lineNumber;
    }

    BreakpointSpec(ReferenceTypeSpec refSpec, String methodId, List<String> methodArgs) throws MalformedMemberNameException {
        super(refSpec);
        this.methodId = methodId;
        this.methodArgs = methodArgs;
        this.lineNumber = 0;
        if (!this.isValidMethodName(methodId)) {
            throw new MalformedMemberNameException(methodId);
        }
    }

    @Override
    EventRequest resolveEventRequest(ReferenceType refType) throws AmbiguousMethodException, AbsentInformationException, InvalidTypeException, NoSuchMethodException, LineNotFoundException {
        Location location = this.location(refType);
        if (location == null) {
            throw new InvalidTypeException();
        }
        EventRequestManager em = refType.virtualMachine().eventRequestManager();
        BreakpointRequest bp = em.createBreakpointRequest(location);
        bp.setSuspendPolicy(this.suspendPolicy);
        bp.enable();
        return bp;
    }

    String methodName() {
        return this.methodId;
    }

    int lineNumber() {
        return this.lineNumber;
    }

    List<String> methodArgs() {
        return this.methodArgs;
    }

    boolean isMethodBreakpoint() {
        return this.methodId != null;
    }

    public int hashCode() {
        return ((Object)this.refSpec).hashCode() + this.lineNumber + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? ((Object)this.methodArgs).hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BreakpointSpec) {
            BreakpointSpec breakpoint = (BreakpointSpec)obj;
            return (this.methodId != null ? this.methodId.equals(breakpoint.methodId) : this.methodId == breakpoint.methodId) && (this.methodArgs != null ? ((Object)this.methodArgs).equals(breakpoint.methodArgs) : this.methodArgs == breakpoint.methodArgs) && ((Object)this.refSpec).equals(breakpoint.refSpec) && this.lineNumber == breakpoint.lineNumber;
        }
        return false;
    }

    @Override
    String errorMessageFor(Exception e) {
        if (e instanceof AmbiguousMethodException) {
            return MessageOutput.format("Method is overloaded; specify arguments", this.methodName());
        }
        if (e instanceof NoSuchMethodException) {
            return MessageOutput.format("No method in", new Object[]{this.methodName(), this.refSpec.toString()});
        }
        if (e instanceof AbsentInformationException) {
            return MessageOutput.format("No linenumber information for", this.refSpec.toString());
        }
        if (e instanceof LineNotFoundException) {
            return MessageOutput.format("No code at line", new Object[]{new Long(this.lineNumber()), this.refSpec.toString()});
        }
        if (e instanceof InvalidTypeException) {
            return MessageOutput.format("Breakpoints can be located only in classes.", this.refSpec.toString());
        }
        return super.errorMessageFor(e);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.refSpec.toString());
        if (this.isMethodBreakpoint()) {
            buffer.append('.');
            buffer.append(this.methodId);
            if (this.methodArgs != null) {
                boolean first = true;
                buffer.append('(');
                for (String arg : this.methodArgs) {
                    if (!first) {
                        buffer.append(',');
                    }
                    buffer.append(arg);
                    first = false;
                }
                buffer.append(")");
            }
        } else {
            buffer.append(':');
            buffer.append(this.lineNumber);
        }
        return MessageOutput.format("breakpoint", buffer.toString());
    }

    private Location location(ReferenceType refType) throws AmbiguousMethodException, AbsentInformationException, NoSuchMethodException, LineNotFoundException {
        Location location = null;
        if (this.isMethodBreakpoint()) {
            Method method = this.findMatchingMethod(refType);
            location = method.location();
        } else {
            List<Location> locs = refType.locationsOfLine(this.lineNumber());
            if (locs.size() == 0) {
                throw new LineNotFoundException();
            }
            location = locs.get(0);
            if (location.method() == null) {
                throw new LineNotFoundException();
            }
        }
        return location;
    }

    private boolean isValidMethodName(String s) {
        return this.isJavaIdentifier(s) || s.equals("<init>") || s.equals("<clinit>");
    }

    private boolean compareArgTypes(Method method, List<String> nameList) {
        List<String> argTypeNames = method.argumentTypeNames();
        if (argTypeNames.size() != nameList.size()) {
            return false;
        }
        int nTypes = argTypeNames.size();
        for (int i = 0; i < nTypes; ++i) {
            String comp2;
            String comp1 = argTypeNames.get(i);
            if (comp1.equals(comp2 = nameList.get(i))) continue;
            if (i != nTypes - 1 || !method.isVarArgs() || !comp2.endsWith("...")) {
                return false;
            }
            int comp1Length = comp1.length();
            if (comp1Length + 1 != comp2.length()) {
                return false;
            }
            return comp1.regionMatches(0, comp2, 0, comp1Length - 2);
        }
        return true;
    }

    private String normalizeArgTypeName(String name) {
        char c;
        int i = 0;
        StringBuffer typePart = new StringBuffer();
        StringBuffer arrayPart = new StringBuffer();
        name = name.trim();
        int nameLength = name.length();
        boolean isVarArgs = name.endsWith("...");
        if (isVarArgs) {
            nameLength -= 3;
        }
        while (i < nameLength && !Character.isWhitespace(c = name.charAt(i)) && c != '[') {
            typePart.append(c);
            ++i;
        }
        while (i < nameLength) {
            c = name.charAt(i);
            if (c == '[' || c == ']') {
                arrayPart.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException(MessageOutput.format("Invalid argument type name"));
            }
            ++i;
        }
        name = typePart.toString();
        if (name.indexOf(46) == -1 || name.startsWith("*.")) {
            try {
                ReferenceType argClass = Env.getReferenceTypeFromToken(name);
                if (argClass != null) {
                    name = argClass.name();
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        name = name + arrayPart.toString();
        if (isVarArgs) {
            name = name + "...";
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ReferenceType refType) throws AmbiguousMethodException, NoSuchMethodException {
        ArrayList<String> argTypeNames = null;
        if (this.methodArgs() != null) {
            argTypeNames = new ArrayList<String>(this.methodArgs().size());
            for (String name : this.methodArgs()) {
                name = this.normalizeArgTypeName(name);
                argTypeNames.add(name);
            }
        }
        Method firstMatch = null;
        Method exactMatch = null;
        int matchCount = 0;
        for (Method candidate : refType.methods()) {
            if (!candidate.name().equals(this.methodName())) continue;
            if (++matchCount == 1) {
                firstMatch = candidate;
            }
            if (argTypeNames == null || !this.compareArgTypes(candidate, argTypeNames)) continue;
            exactMatch = candidate;
            break;
        }
        Method method = null;
        if (exactMatch != null) {
            return exactMatch;
        }
        if (argTypeNames != null) throw new NoSuchMethodException(this.methodName());
        if (matchCount <= 0) throw new NoSuchMethodException(this.methodName());
        if (matchCount != 1) throw new AmbiguousMethodException();
        return firstMatch;
    }
}

