/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class TypeScript
extends JPanel {
    private JTextArea history;
    private JTextField entry;
    private JLabel promptLabel;
    private JScrollBar historyVScrollBar;
    private JScrollBar historyHScrollBar;
    private boolean echoInput = false;
    private boolean nlPending = false;
    private static String newline = System.getProperty("line.separator");

    public TypeScript(String prompt) {
        this(prompt, true);
    }

    public TypeScript(String prompt, boolean echoInput) {
        this.echoInput = echoInput;
        this.setLayout(new BoxLayout(this, 1));
        this.history = new JTextArea(0, 0);
        this.history.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.history);
        this.historyVScrollBar = scroller.getVerticalScrollBar();
        this.historyHScrollBar = scroller.getHorizontalScrollBar();
        this.add(scroller);
        JPanel cmdLine = new JPanel();
        cmdLine.setLayout(new BoxLayout(cmdLine, 0));
        this.promptLabel = new JLabel(prompt + " ");
        cmdLine.add(this.promptLabel);
        this.entry = new JTextField();
        this.entry.setMaximumSize(new Dimension(1000, 20));
        cmdLine.add(this.entry);
        this.add(cmdLine);
    }

    public void setPrompt(String prompt) {
        this.promptLabel.setText(prompt + " ");
    }

    public void append(String text) {
        this.history.append(text);
        this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
        this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
    }

    public void newline() {
        this.history.append(newline);
        this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
        this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
    }

    public void flush() {
    }

    public void addActionListener(ActionListener a) {
        this.entry.addActionListener(a);
    }

    public void removeActionListener(ActionListener a) {
        this.entry.removeActionListener(a);
    }

    public String readln() {
        String text = this.entry.getText();
        this.entry.setText("");
        if (this.echoInput) {
            this.history.append(">>>");
            this.history.append(text);
            this.history.append(newline);
            this.historyVScrollBar.setValue(this.historyVScrollBar.getMaximum());
            this.historyHScrollBar.setValue(this.historyHScrollBar.getMinimum());
        }
        return text;
    }
}

