/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.tools.example.debug.gui.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceModel
extends AbstractListModel {
    private File path;
    boolean isActuallySource = true;
    private List<ReferenceType> classes = new ArrayList<ReferenceType>();
    private Environment env;
    private List<Line> sourceLines = null;
    public static final Line prototypeCellValue = new Line("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*()_+{}|:<>?`-=[];',.XXXXXXXXXXXX/\\\"");

    SourceModel(Environment env, File path) {
        this.env = env;
        this.path = path;
    }

    public SourceModel(String message) {
        this.path = null;
        this.setMessage(message);
    }

    private void setMessage(String message) {
        this.isActuallySource = false;
        this.sourceLines = new ArrayList<Line>();
        this.sourceLines.add(new Line(message));
    }

    @Override
    public Object getElementAt(int index) {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.get(index);
    }

    @Override
    public int getSize() {
        if (this.sourceLines == null) {
            this.initialize();
        }
        return this.sourceLines.size();
    }

    public File fileName() {
        return this.path;
    }

    public BufferedReader sourceReader() throws IOException {
        return new BufferedReader(new FileReader(this.path));
    }

    public Line line(int lineNo) {
        int index;
        if (this.sourceLines == null) {
            this.initialize();
        }
        if ((index = lineNo - 1) >= this.sourceLines.size() || index < 0) {
            return null;
        }
        return this.sourceLines.get(index);
    }

    public String sourceLine(int lineNo) {
        Line line = this.line(lineNo);
        if (line == null) {
            return null;
        }
        return line.text;
    }

    void addClass(ReferenceType refType) {
        if (this.classes.indexOf(refType) == -1) {
            this.classes.add(refType);
            if (this.sourceLines != null) {
                this.markClassLines(refType);
            }
        }
    }

    public List<ReferenceType> referenceTypes() {
        return Collections.unmodifiableList(this.classes);
    }

    private void initialize() {
        try {
            this.rawInit();
        }
        catch (IOException exc) {
            this.setMessage("[Error reading source code]");
        }
    }

    public void showBreakpoint(int ln, boolean hasBreakpoint) {
        this.line((int)ln).hasBreakpoint = hasBreakpoint;
        this.fireContentsChanged(this, ln, ln);
    }

    public void showExecutable(int ln, ReferenceType refType) {
        this.line((int)ln).refType = refType;
        this.fireContentsChanged(this, ln, ln);
    }

    private void markClassLines(ReferenceType refType) {
        for (Method meth : refType.methods()) {
            try {
                for (Location loc : meth.allLineLocations()) {
                    this.showExecutable(loc.lineNumber(), refType);
                }
            }
            catch (AbsentInformationException exc) {
            }
        }
        for (BreakpointRequest bp : this.env.getExecutionManager().eventRequestManager().breakpointRequests()) {
            Location loc;
            if (bp.location() == null || !((Object)(loc = bp.location()).declaringType()).equals(refType)) continue;
            this.showBreakpoint(loc.lineNumber(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rawInit() throws IOException {
        this.sourceLines = new ArrayList<Line>();
        BufferedReader reader = this.sourceReader();
        try {
            String line = reader.readLine();
            while (line != null) {
                this.sourceLines.add(new Line(this.expandTabs(line)));
                line = reader.readLine();
            }
        }
        finally {
            reader.close();
        }
        for (ReferenceType refType : this.classes) {
            this.markClassLines(refType);
        }
    }

    private String expandTabs(String s) {
        int col = 0;
        int len = s.length();
        StringBuffer sb = new StringBuffer(132);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            sb.append(c);
            if (c == '\t') {
                int pad = 8 - col % 8;
                for (int j = 0; j < pad; ++j) {
                    sb.append(' ');
                }
                col += pad;
                continue;
            }
            ++col;
        }
        return sb.toString();
    }

    public static class Line {
        public String text;
        public boolean hasBreakpoint = false;
        public ReferenceType refType = null;

        Line(String text) {
            this.text = text;
        }

        public boolean isExecutable() {
            return this.refType != null;
        }

        public boolean hasBreakpoint() {
            return this.hasBreakpoint;
        }
    }
}

