/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String searchPath) {
        StringTokenizer st = new StringTokenizer(searchPath, File.pathSeparator);
        ArrayList<String> dlist = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            dlist.add(st.nextToken());
        }
        this.pathString = searchPath;
        this.pathArray = dlist.toArray(new String[dlist.size()]);
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public File resolve(String relativeFileName) {
        for (int i = 0; i < this.pathArray.length; ++i) {
            File path = new File(this.pathArray[i], relativeFileName);
            if (!path.exists()) continue;
            return path;
        }
        return null;
    }

    public String[] children(String relativeDirName, FilenameFilter filter) {
        TreeSet<String> s = new TreeSet<String>();
        for (int i = 0; i < this.pathArray.length; ++i) {
            String[] childArray;
            File path = new File(this.pathArray[i], relativeDirName);
            if (!path.exists() || (childArray = path.list(filter)) == null) continue;
            for (int j = 0; j < childArray.length; ++j) {
                if (s.contains(childArray[j])) continue;
                s.add(childArray[j]);
            }
        }
        return s.toArray(new String[s.size()]);
    }
}

