/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.CommandInterpreter;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.SourceManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JToolBar;

class JDBToolBar
extends JToolBar {
    Environment env;
    ExecutionManager runtime;
    ClassManager classManager;
    SourceManager sourceManager;
    CommandInterpreter interpreter;

    JDBToolBar(Environment env) {
        this.env = env;
        this.runtime = env.getExecutionManager();
        this.classManager = env.getClassManager();
        this.sourceManager = env.getSourceManager();
        this.interpreter = new CommandInterpreter(env, true);
        this.addTool("Run application", "run", "run");
        this.addTool("Connect to application", "connect", "connect");
        this.addSeparator();
        this.addTool("Step into next line", "step", "step");
        this.addTool("Step over next line", "next", "next");
        this.addTool("Step out of current method call", "step up", "step up");
        this.addSeparator();
        this.addTool("Suspend execution", "interrupt", "interrupt");
        this.addTool("Continue execution", "cont", "cont");
        this.addSeparator();
        this.addTool("Move up one stack frame", "up", "up");
        this.addTool("Move down one stack frame", "down", "down");
    }

    private void addTool(String toolTip, String labelText, String command) {
        JButton button = new JButton(labelText);
        button.setToolTipText(toolTip);
        final String cmd = command;
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JDBToolBar.this.interpreter.executeCommand(cmd);
            }
        });
        this.add(button);
    }
}

