/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.ThreadGroupIterator;
import com.sun.tools.example.debug.bdi.ThreadIterator;
import com.sun.tools.example.debug.bdi.Utils;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.gui.ClassManager;
import com.sun.tools.example.debug.gui.ContextManager;
import com.sun.tools.example.debug.gui.Environment;
import com.sun.tools.example.debug.gui.LaunchTool;
import com.sun.tools.example.debug.gui.OutputSink;
import com.sun.tools.example.debug.gui.SearchPath;
import com.sun.tools.example.debug.gui.SourceManager;
import com.sun.tools.example.debug.gui.SourceModel;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class CommandInterpreter {
    boolean echo;
    Environment env;
    private ContextManager context;
    private ExecutionManager runtime;
    private ClassManager classManager;
    private SourceManager sourceManager;
    private OutputSink out;
    private String lastCommand = "help";
    private ThreadReference[] threads = null;
    private ThreadGroupReference defaultThreadGroup;

    public CommandInterpreter(Environment env) {
        this(env, true);
    }

    public CommandInterpreter(Environment env, boolean echo) {
        this.env = env;
        this.echo = echo;
        this.runtime = env.getExecutionManager();
        this.context = env.getContextManager();
        this.classManager = env.getClassManager();
        this.sourceManager = env.getSourceManager();
    }

    private ThreadReference[] threads() throws NoSessionException {
        if (this.threads == null) {
            ThreadIterator ti = new ThreadIterator(this.getDefaultThreadGroup());
            ArrayList<ThreadReference> tlist = new ArrayList<ThreadReference>();
            while (ti.hasNext()) {
                tlist.add(ti.nextThread());
            }
            this.threads = tlist.toArray(new ThreadReference[tlist.size()]);
        }
        return this.threads;
    }

    private ThreadReference findThread(String idToken) throws NoSessionException {
        ThreadReference thread = null;
        String id = idToken.startsWith("t@") ? idToken.substring(2) : idToken;
        try {
            ThreadReference[] threads = this.threads();
            long threadID = Long.parseLong(id, 16);
            for (int i = 0; i < threads.length; ++i) {
                if (threads[i].uniqueID() != threadID) continue;
                thread = threads[i];
                break;
            }
            if (thread == null) {
                this.env.failure("\"" + idToken + "\" is not a valid thread id.");
            }
        }
        catch (NumberFormatException e) {
            this.env.error("Thread id \"" + idToken + "\" is ill-formed.");
            thread = null;
        }
        return thread;
    }

    private ThreadIterator allThreads() throws NoSessionException {
        this.threads = null;
        return new ThreadIterator(this.runtime.topLevelThreadGroups());
    }

    private ThreadIterator currentThreadGroupThreads() throws NoSessionException {
        this.threads = null;
        return new ThreadIterator(this.getDefaultThreadGroup());
    }

    private ThreadGroupIterator allThreadGroups() throws NoSessionException {
        this.threads = null;
        return new ThreadGroupIterator(this.runtime.topLevelThreadGroups());
    }

    private ThreadGroupReference getDefaultThreadGroup() throws NoSessionException {
        if (this.defaultThreadGroup == null) {
            this.defaultThreadGroup = this.runtime.systemThreadGroup();
        }
        return this.defaultThreadGroup;
    }

    private void setDefaultThreadGroup(ThreadGroupReference tg) {
        this.defaultThreadGroup = tg;
    }

    private void commandClasses() throws NoSessionException {
        OutputSink out = this.env.getOutputSink();
        for (ReferenceType refType : this.runtime.allClasses()) {
            out.println(refType.name());
        }
        out.show();
    }

    private void commandMethods(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("No class specified.");
            return;
        }
        String idClass = t.nextToken();
        ReferenceType cls = this.findClass(idClass);
        if (cls != null) {
            List<Method> methods = cls.allMethods();
            OutputSink out = this.env.getOutputSink();
            for (int i = 0; i < methods.size(); ++i) {
                Method method = methods.get(i);
                out.print(method.declaringType().name() + " " + method.name() + "(");
                Iterator<String> it = method.argumentTypeNames().iterator();
                if (it.hasNext()) {
                    while (true) {
                        out.print(it.next());
                        if (!it.hasNext()) break;
                        out.print(", ");
                    }
                }
                out.println(")");
            }
            out.show();
        } else {
            this.env.failure("\"" + idClass + "\" is not a valid id or class name.");
        }
    }

    private ReferenceType findClass(String pattern) throws NoSessionException {
        List<ReferenceType> results = this.runtime.findClassesMatchingPattern(pattern);
        if (results.size() > 0) {
            return results.get(0);
        }
        return null;
    }

    private void commandThreads(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            OutputSink out = this.env.getOutputSink();
            this.printThreadGroup(out, this.getDefaultThreadGroup(), 0);
            out.show();
            return;
        }
        String name = t.nextToken();
        ThreadGroupReference tg = this.findThreadGroup(name);
        if (tg == null) {
            this.env.failure(name + " is not a valid threadgroup name.");
        } else {
            OutputSink out = this.env.getOutputSink();
            this.printThreadGroup(out, tg, 0);
            out.show();
        }
    }

    private ThreadGroupReference findThreadGroup(String name) throws NoSessionException {
        ThreadGroupIterator tgi = this.allThreadGroups();
        while (tgi.hasNext()) {
            ThreadGroupReference tg = tgi.nextThreadGroup();
            if (!tg.name().equals(name)) continue;
            return tg;
        }
        return null;
    }

    private int printThreadGroup(OutputSink out, ThreadGroupReference tg, int iThread) {
        out.println("Group " + tg.name() + ":");
        List<ThreadReference> tlist = tg.threads();
        int maxId = 0;
        int maxName = 0;
        for (int i = 0; i < tlist.size(); ++i) {
            String name;
            int iDot;
            ThreadReference thr = tlist.get(i);
            int len = Utils.description(thr).length();
            if (len > maxId) {
                maxId = len;
            }
            if ((iDot = (name = thr.name()).lastIndexOf(46)) >= 0 && name.length() > iDot) {
                name = name.substring(iDot + 1);
            }
            if (name.length() <= maxName) continue;
            maxName = name.length();
        }
        String maxNumString = String.valueOf(iThread + tlist.size());
        int maxNumDigits = maxNumString.length();
        for (int i = 0; i < tlist.size(); ++i) {
            ThreadReference thr = tlist.get(i);
            char[] buf = new char[80];
            for (int j = 0; j < 79; ++j) {
                buf[j] = 32;
            }
            buf[79] = '\u0000';
            StringBuffer sbOut = new StringBuffer();
            sbOut.append(buf);
            String numString = String.valueOf(iThread + i + 1);
            sbOut.insert(maxNumDigits - numString.length(), numString);
            sbOut.insert(maxNumDigits, ".");
            int iBuf = maxNumDigits + 2;
            sbOut.insert(iBuf, Utils.description(thr));
            iBuf += maxId + 1;
            String name = thr.name();
            int iDot = name.lastIndexOf(46);
            if (iDot >= 0 && name.length() > iDot) {
                name = name.substring(iDot + 1);
            }
            sbOut.insert(iBuf, name);
            sbOut.insert(iBuf += maxName + 1, Utils.getStatus(thr));
            sbOut.setLength(79);
            out.println(sbOut.toString());
        }
        for (ThreadGroupReference tg0 : tg.threadGroups()) {
            if (tg.equals(tg0)) continue;
            iThread += this.printThreadGroup(out, tg0, iThread + tlist.size());
        }
        return tlist.size();
    }

    private void commandThreadGroups() throws NoSessionException {
        ThreadGroupIterator it = this.allThreadGroups();
        int cnt = 0;
        OutputSink out = this.env.getOutputSink();
        while (it.hasNext()) {
            ThreadGroupReference tg = it.nextThreadGroup();
            out.println("" + ++cnt + ". " + Utils.description(tg) + " " + tg.name());
        }
        out.show();
    }

    private void commandThread(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Thread number not specified.");
            return;
        }
        ThreadReference thread = this.findThread(t.nextToken());
        if (thread != null) {
            this.context.setCurrentThread(thread);
        }
    }

    private void commandThreadGroup(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Threadgroup name not specified.");
            return;
        }
        String name = t.nextToken();
        ThreadGroupReference tg = this.findThreadGroup(name);
        if (tg == null) {
            this.env.failure(name + " is not a valid threadgroup name.");
        } else {
            this.setDefaultThreadGroup(tg);
        }
    }

    private void commandRun(StringTokenizer t) throws NoSessionException {
        if (this.doLoad(false, t)) {
            this.env.notice("Running ...");
        }
    }

    private void commandLoad(StringTokenizer t) throws NoSessionException {
        if (this.doLoad(true, t)) {
            // empty if block
        }
    }

    private boolean doLoad(boolean suspended, StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            String clname = this.context.getMainClassName();
            if (!clname.equals("")) {
                try {
                    String vmArgs = this.context.getVmArguments();
                    this.runtime.run(suspended, vmArgs, clname, this.context.getProgramArguments());
                    return true;
                }
                catch (VMLaunchFailureException e) {
                    this.env.failure("Attempt to launch main class \"" + clname + "\" failed.");
                }
            } else {
                this.env.failure("No main class specifed and no current default defined.");
            }
        } else {
            String clname = t.nextToken();
            StringBuffer sbuf = new StringBuffer();
            while (t.hasMoreTokens()) {
                String tok = t.nextToken();
                sbuf.append(tok);
                if (!t.hasMoreTokens()) continue;
                sbuf.append(' ');
            }
            String args = sbuf.toString();
            try {
                String vmArgs = this.context.getVmArguments();
                this.runtime.run(suspended, vmArgs, clname, args);
                this.context.setMainClassName(clname);
                this.context.setProgramArguments(args);
                return true;
            }
            catch (VMLaunchFailureException e) {
                this.env.failure("Attempt to launch main class \"" + clname + "\" failed.");
            }
        }
        return false;
    }

    private void commandConnect(StringTokenizer t) {
        try {
            LaunchTool.queryAndLaunchVM(this.runtime);
        }
        catch (VMLaunchFailureException e) {
            this.env.failure("Attempt to connect failed.");
        }
    }

    private void commandAttach(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            String portName = this.context.getRemotePort();
            if (!portName.equals("")) {
                try {
                    this.runtime.attach(portName);
                }
                catch (VMLaunchFailureException e) {
                    this.env.failure("Attempt to attach to port \"" + portName + "\" failed.");
                }
            } else {
                this.env.failure("No port specifed and no current default defined.");
            }
        } else {
            String portName = t.nextToken();
            try {
                this.runtime.attach(portName);
            }
            catch (VMLaunchFailureException e) {
                this.env.failure("Attempt to attach to port \"" + portName + "\" failed.");
            }
            this.context.setRemotePort(portName);
        }
    }

    private void commandDetach(StringTokenizer t) throws NoSessionException {
        this.runtime.detach();
    }

    private void commandInterrupt(StringTokenizer t) throws NoSessionException {
        this.runtime.interrupt();
    }

    private void commandSuspend(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            ThreadIterator ti = this.currentThreadGroupThreads();
            while (ti.hasNext()) {
                ti.nextThread().suspend();
            }
            this.env.notice("All (non-system) threads suspended.");
        } else {
            while (t.hasMoreTokens()) {
                ThreadReference thread = this.findThread(t.nextToken());
                if (thread == null) continue;
                this.runtime.suspendThread(thread);
            }
        }
    }

    private void commandResume(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            ThreadIterator ti = this.currentThreadGroupThreads();
            while (ti.hasNext()) {
                ti.nextThread().resume();
            }
            this.env.notice("All threads resumed.");
        } else {
            while (t.hasMoreTokens()) {
                ThreadReference thread = this.findThread(t.nextToken());
                if (thread == null) continue;
                this.runtime.resumeThread(thread);
            }
        }
    }

    private void commandCont() throws NoSessionException {
        try {
            this.runtime.go();
        }
        catch (VMNotInterruptedException e) {
            this.env.notice("Target VM is already running.");
        }
    }

    private void commandStep(StringTokenizer t) throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        try {
            if (t.hasMoreTokens() && t.nextToken().toLowerCase().equals("up")) {
                this.runtime.stepOut(current);
            } else {
                this.runtime.stepIntoLine(current);
            }
        }
        catch (AbsentInformationException e) {
            this.env.failure("No linenumber information available -- Try \"stepi\" to step by instructions.");
        }
    }

    private void commandStepi() throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        this.runtime.stepIntoInstruction(current);
    }

    private void commandNext() throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        try {
            this.runtime.stepOverLine(current);
        }
        catch (AbsentInformationException e) {
            this.env.failure("No linenumber information available -- Try \"nexti\" to step by instructions.");
        }
    }

    private void commandNexti() throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        this.runtime.stepOverInstruction(current);
    }

    private void commandKill(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Usage: kill <threadgroup name> or <thread id>");
            return;
        }
        while (t.hasMoreTokens()) {
            String idToken = t.nextToken();
            ThreadReference thread = this.findThread(idToken);
            if (thread != null) {
                this.runtime.stopThread(thread);
                this.env.notice("Thread " + thread.name() + " killed.");
                return;
            }
            ThreadGroupIterator itg = this.allThreadGroups();
            while (itg.hasNext()) {
                ThreadGroupReference tg = itg.nextThreadGroup();
                if (!tg.name().equals(idToken)) continue;
                ThreadIterator it = new ThreadIterator(tg);
                while (it.hasNext()) {
                    this.runtime.stopThread(it.nextThread());
                }
                this.env.notice("Threadgroup " + tg.name() + "killed.");
                return;
            }
            this.env.failure("\"" + idToken + "\" is not a valid threadgroup or id.");
        }
    }

    int readCount(StringTokenizer t) {
        int cnt = 1;
        if (t.hasMoreTokens()) {
            String idToken = t.nextToken();
            try {
                cnt = Integer.valueOf(idToken);
            }
            catch (NumberFormatException e) {
                cnt = -1;
            }
        }
        return cnt;
    }

    void commandUp(StringTokenizer t) throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        int nLevels = this.readCount(t);
        if (nLevels <= 0) {
            this.env.error("usage: up [n frames]");
            return;
        }
        try {
            int delta = this.context.moveCurrentFrameIndex(current, -nLevels);
            if (delta == 0) {
                this.env.notice("Already at top of stack.");
            } else if (-delta < nLevels) {
                this.env.notice("Moved up " + delta + " frames to top of stack.");
            }
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandDown(StringTokenizer t) throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        int nLevels = this.readCount(t);
        if (nLevels <= 0) {
            this.env.error("usage: down [n frames]");
            return;
        }
        try {
            int delta = this.context.moveCurrentFrameIndex(current, nLevels);
            if (delta == 0) {
                this.env.notice("Already at bottom of stack.");
            } else if (delta < nLevels) {
                this.env.notice("Moved down " + delta + " frames to bottom of stack.");
            }
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandFrame(StringTokenizer t) throws NoSessionException {
        int n;
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No current thread.");
            return;
        }
        if (!t.hasMoreTokens()) {
            this.env.error("usage: frame <frame-index>");
            return;
        }
        String idToken = t.nextToken();
        try {
            n = Integer.valueOf(idToken);
        }
        catch (NumberFormatException e) {
            n = 0;
        }
        if (n <= 0) {
            this.env.error("use positive frame index");
            return;
        }
        try {
            int delta = this.context.setCurrentFrameIndex(current, n);
            if (delta == 0) {
                this.env.notice("Frame unchanged.");
            } else if (delta < 0) {
                this.env.notice("Moved up " + -delta + " frames.");
            } else {
                this.env.notice("Moved down " + delta + " frames.");
            }
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
        }
    }

    private void commandWhere(StringTokenizer t, boolean showPC) throws NoSessionException {
        ThreadReference current = this.context.getCurrentThread();
        if (!t.hasMoreTokens()) {
            if (current == null) {
                this.env.error("No thread specified.");
                return;
            }
            this.dumpStack(current, showPC);
        } else {
            String token = t.nextToken();
            if (token.toLowerCase().equals("all")) {
                ThreadIterator it = this.allThreads();
                while (it.hasNext()) {
                    ThreadReference thread = it.next();
                    this.out.println(thread.name() + ": ");
                    this.dumpStack(thread, showPC);
                }
            } else {
                ThreadReference thread = this.findThread(t.nextToken());
                if (thread != null) {
                    this.context.setCurrentThread(thread);
                }
                this.dumpStack(thread, showPC);
            }
        }
    }

    private void dumpStack(ThreadReference thread, boolean showPC) {
        List<StackFrame> stack = null;
        try {
            stack = thread.frames();
        }
        catch (IncompatibleThreadStateException e) {
            this.env.failure("Thread is not suspended.");
        }
        int frameIndex = 0;
        if (stack == null) {
            this.env.failure("Thread is not running (no stack).");
        } else {
            OutputSink out = this.env.getOutputSink();
            int nFrames = stack.size();
            for (int i = frameIndex; i < nFrames; ++i) {
                long pc;
                StackFrame frame = stack.get(i);
                Location loc = frame.location();
                Method meth = loc.method();
                out.print("  [" + (i + 1) + "] ");
                out.print(meth.declaringType().name());
                out.print('.');
                out.print(meth.name());
                out.print(" (");
                if (meth.isNative()) {
                    out.print("native method");
                } else if (loc.lineNumber() != -1) {
                    try {
                        out.print(loc.sourceName());
                    }
                    catch (AbsentInformationException e) {
                        out.print("<unknown>");
                    }
                    out.print(':');
                    out.print(loc.lineNumber());
                }
                out.print(')');
                if (showPC && (pc = loc.codeIndex()) != -1L) {
                    out.print(", pc = " + pc);
                }
                out.println();
            }
            out.show();
        }
    }

    private void listEventRequests() throws NoSessionException {
        List<EventRequestSpec> specs = this.runtime.eventRequestSpecs();
        if (specs.isEmpty()) {
            this.env.notice("No breakpoints/watchpoints/exceptions set.");
        } else {
            OutputSink out = this.env.getOutputSink();
            out.println("Current breakpoints/watchpoints/exceptions set:");
            for (EventRequestSpec bp : specs) {
                out.println("\t" + bp);
            }
            out.show();
        }
    }

    private BreakpointSpec parseBreakpointSpec(String bptSpec) {
        String rest;
        StringTokenizer t = new StringTokenizer(bptSpec);
        BreakpointSpec bpSpec = null;
        String token = t.nextToken("@:( \t\n\r");
        try {
            rest = t.nextToken("").trim();
        }
        catch (NoSuchElementException e) {
            rest = null;
        }
        if (rest != null && rest.startsWith("@")) {
            t = new StringTokenizer(rest.substring(1));
            String sourceName = token;
            String lineToken = t.nextToken();
            int lineNumber = Integer.valueOf(lineToken);
            if (t.hasMoreTokens()) {
                return null;
            }
            bpSpec = this.runtime.createSourceLineBreakpoint(sourceName, lineNumber);
        } else if (rest != null && rest.startsWith(":")) {
            t = new StringTokenizer(rest.substring(1));
            String classId = token;
            String lineToken = t.nextToken();
            int lineNumber = Integer.valueOf(lineToken);
            if (t.hasMoreTokens()) {
                return null;
            }
            bpSpec = this.runtime.createClassLineBreakpoint(classId, lineNumber);
        } else {
            int idot = token.lastIndexOf(".");
            if (idot <= 0 || idot >= token.length() - 1) {
                return null;
            }
            String methodName = token.substring(idot + 1);
            String classId = token.substring(0, idot);
            ArrayList<String> argumentList = null;
            if (rest != null) {
                if (!rest.startsWith("(") || !rest.endsWith(")")) {
                    return null;
                }
                rest = rest.substring(1, rest.length() - 1);
                argumentList = new ArrayList<String>();
                t = new StringTokenizer(rest, ",");
                while (t.hasMoreTokens()) {
                    argumentList.add(t.nextToken());
                }
            }
            bpSpec = this.runtime.createMethodBreakpoint(classId, methodName, argumentList);
        }
        return bpSpec;
    }

    private void commandStop(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.listEventRequests();
        } else {
            BreakpointSpec bpSpec;
            String token = t.nextToken();
            if (token.equals("at") || token.equals("in")) {
                if (t.hasMoreTokens()) {
                    token = t.nextToken();
                } else {
                    this.env.error("Missing breakpoint specification.");
                    return;
                }
            }
            if ((bpSpec = this.parseBreakpointSpec(token)) != null) {
                this.runtime.install(bpSpec);
            } else {
                this.env.error("Ill-formed breakpoint specification.");
            }
        }
    }

    private void commandClear(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.listEventRequests();
            return;
        }
        BreakpointSpec bpSpec = this.parseBreakpointSpec(t.nextToken());
        if (bpSpec != null) {
            List<EventRequestSpec> specs = this.runtime.eventRequestSpecs();
            if (specs.isEmpty()) {
                this.env.notice("No breakpoints set.");
            } else {
                ArrayList<EventRequestSpec> toDelete = new ArrayList<EventRequestSpec>();
                for (EventRequestSpec spec : specs) {
                    if (!spec.equals(bpSpec)) continue;
                    toDelete.add(spec);
                }
                if (toDelete.size() <= 1) {
                    this.env.notice("No matching breakpoint set.");
                }
                for (EventRequestSpec spec : toDelete) {
                    this.runtime.delete(spec);
                }
            }
        } else {
            this.env.error("Ill-formed breakpoint specification.");
        }
    }

    private void commandList(StringTokenizer t) throws NoSessionException {
        Location loc;
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.error("No thread specified.");
            return;
        }
        try {
            StackFrame frame = this.context.getCurrentFrame(current);
            if (frame == null) {
                this.env.failure("Thread has not yet begun execution.");
                return;
            }
            loc = frame.location();
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        SourceModel source = this.sourceManager.sourceForLocation(loc);
        if (source == null) {
            if (loc.method().isNative()) {
                this.env.failure("Current method is native.");
                return;
            }
            this.env.failure("No source available for " + Utils.locationString(loc) + ".");
            return;
        }
        ReferenceType refType = loc.declaringType();
        int lineno = loc.lineNumber();
        if (t.hasMoreTokens()) {
            String id = t.nextToken();
            try {
                lineno = Integer.valueOf(id);
            }
            catch (NumberFormatException nfe) {
                List<Method> meths = refType.methodsByName(id);
                if (meths == null || meths.size() == 0) {
                    this.env.failure(id + " is not a valid line number or " + "method name for class " + refType.name());
                    return;
                }
                if (meths.size() > 1) {
                    this.env.failure(id + " is an ambiguous method name in" + refType.name());
                    return;
                }
                loc = meths.get(0).location();
                lineno = loc.lineNumber();
            }
        }
        int startLine = lineno > 4 ? lineno - 4 : 1;
        int endLine = startLine + 9;
        String sourceLine = source.sourceLine(lineno);
        if (sourceLine == null) {
            this.env.failure("" + lineno + " is an invalid line number for " + refType.name());
        } else {
            OutputSink out = this.env.getOutputSink();
            for (int i = startLine; i <= endLine && (sourceLine = source.sourceLine(i)) != null; ++i) {
                out.print(i);
                out.print("\t");
                if (i == lineno) {
                    out.print("=> ");
                } else {
                    out.print("   ");
                }
                out.println(sourceLine);
            }
            out.show();
        }
    }

    private void commandUse(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.out.println(this.sourceManager.getSourcePath().asString());
        } else {
            this.sourceManager.setSourcePath(new SearchPath(t.nextToken()));
        }
    }

    private void commandSourcepath(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.out.println(this.sourceManager.getSourcePath().asString());
        } else {
            this.sourceManager.setSourcePath(new SearchPath(t.nextToken()));
        }
    }

    private void commandClasspath(StringTokenizer t) {
        if (!t.hasMoreTokens()) {
            this.out.println(this.classManager.getClassPath().asString());
        } else {
            this.classManager.setClassPath(new SearchPath(t.nextToken()));
        }
    }

    private void commandView(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            String name = t.nextToken();
            if (name.endsWith(".java") || name.indexOf(File.separatorChar) >= 0) {
                this.env.viewSource(name);
            } else {
                String fileName = name.replace('.', File.separatorChar) + ".java";
                this.env.viewSource(fileName);
            }
        }
    }

    private void commandLocals() throws NoSessionException {
        List<LocalVariable> vars;
        StackFrame frame;
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No default thread specified: use the \"thread\" command first.");
            return;
        }
        try {
            frame = this.context.getCurrentFrame(current);
            if (frame == null) {
                this.env.failure("Thread has not yet created any stack frames.");
                return;
            }
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        try {
            vars = frame.visibleVariables();
            if (vars == null || vars.size() == 0) {
                this.env.failure("No local variables");
                return;
            }
        }
        catch (AbsentInformationException e) {
            this.env.failure("Local variable information not available. Compile with -g to generate variable information");
            return;
        }
        OutputSink out = this.env.getOutputSink();
        out.println("Method arguments:");
        for (LocalVariable var : vars) {
            if (!var.isArgument()) continue;
            this.printVar(out, var, frame);
        }
        out.println("Local variables:");
        for (LocalVariable var : vars) {
            if (var.isArgument()) continue;
            this.printVar(out, var, frame);
        }
        out.show();
    }

    private void commandMonitor(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            this.env.getMonitorListModel().add(t.nextToken(""));
        }
    }

    private void commandUnmonitor(StringTokenizer t) throws NoSessionException {
        if (!t.hasMoreTokens()) {
            this.env.error("Argument required");
        } else {
            this.env.getMonitorListModel().remove(t.nextToken(""));
        }
    }

    private void printVar(OutputSink out, LocalVariable var, StackFrame frame) {
        out.print("  " + var.name());
        if (var.isVisible(frame)) {
            Value val = frame.getValue(var);
            out.println(" = " + val.toString());
        } else {
            out.println(" is not in scope");
        }
    }

    private void commandPrint(StringTokenizer t, boolean dumpObject) throws NoSessionException {
        StackFrame frame;
        if (!t.hasMoreTokens()) {
            this.env.error("No expression specified.");
            return;
        }
        ThreadReference current = this.context.getCurrentThread();
        if (current == null) {
            this.env.failure("No default thread specified: use the \"thread\" command first.");
            return;
        }
        try {
            frame = this.context.getCurrentFrame(current);
            if (frame == null) {
                this.env.failure("Thread has not yet created any stack frames.");
                return;
            }
        }
        catch (VMNotInterruptedException e) {
            this.env.failure("Target VM must be in interrupted state.");
            return;
        }
        while (t.hasMoreTokens()) {
            String expr = t.nextToken("");
            Value val = null;
            try {
                val = this.runtime.evaluate(frame, expr);
            }
            catch (Exception e) {
                this.env.error("Exception: " + e);
            }
            if (val == null) {
                return;
            }
            OutputSink out = this.env.getOutputSink();
            if (dumpObject && val instanceof ObjectReference && !(val instanceof StringReference)) {
                ObjectReference obj = (ObjectReference)val;
                ReferenceType refType = obj.referenceType();
                out.println(expr + " = " + val.toString() + " {");
                this.dump(out, obj, refType, refType);
                out.println("}");
            } else {
                out.println(expr + " = " + val.toString());
            }
            out.show();
        }
    }

    private void dump(OutputSink out, ObjectReference obj, ReferenceType refType, ReferenceType refTypeBase) {
        for (Field field : refType.fields()) {
            out.print("    ");
            if (!((Object)refType).equals(refTypeBase)) {
                out.print(refType.name() + ".");
            }
            out.print(field.name() + ": ");
            Value o = obj.getValue(field);
            out.println(o == null ? "null" : o.toString());
        }
        if (refType instanceof ClassType) {
            ClassType sup = ((ClassType)refType).superclass();
            if (sup != null) {
                this.dump(out, obj, sup, refTypeBase);
            }
        } else if (refType instanceof InterfaceType) {
            for (InterfaceType sup : ((InterfaceType)refType).superinterfaces()) {
                this.dump(out, obj, sup, refTypeBase);
            }
        }
    }

    private void help() {
        this.out.println("** command list **");
        this.out.println("threads [threadgroup]     -- list threads");
        this.out.println("thread <thread id>        -- set default thread");
        this.out.println("suspend [thread id(s)]    -- suspend threads (default: all)");
        this.out.println("resume [thread id(s)]     -- resume threads (default: all)");
        this.out.println("where [thread id] | all   -- dump a thread's stack");
        this.out.println("wherei [thread id] | all  -- dump a thread's stack, with pc info");
        this.out.println("threadgroups              -- list threadgroups");
        this.out.println("threadgroup <name>        -- set current threadgroup\n");
        this.out.println("dump <expression>         -- print all object information\n");
        this.out.println("locals                    -- print all local variables in current stack frame\n");
        this.out.println("classes                   -- list currently known classes");
        this.out.println("methods <class id>        -- list a class's methods\n");
        this.out.println("stop [in] <class id>.<method>[(argument_type,...)] -- set a breakpoint in a method");
        this.out.println("stop [at] <class id>:<line> -- set a breakpoint at a line");
        this.out.println("up [n frames]             -- move up a thread's stack");
        this.out.println("down [n frames]           -- move down a thread's stack");
        this.out.println("frame <frame-id>           -- to a frame");
        this.out.println("clear <class id>.<method>[(argument_type,...)]   -- clear a breakpoint in a method");
        this.out.println("clear <class id>:<line>   -- clear a breakpoint at a line");
        this.out.println("clear                     -- list breakpoints");
        this.out.println("step                      -- execute current line");
        this.out.println("step up                   -- execute until the current method returns to its caller");
        this.out.println("stepi                     -- execute current instruction");
        this.out.println("next                      -- step one line (step OVER calls)");
        this.out.println("nexti                     -- step one instruction (step OVER calls)");
        this.out.println("cont                      -- continue execution from breakpoint\n");
        this.out.println("view classname|filename   -- display source file");
        this.out.println("list [line number|method] -- print source code context at line or method");
        this.out.println("use <source file path>    -- display or change the source path\n");
        this.out.println("sourcepath <source file path>    -- display or change the source path\n");
        this.out.println("classpath <class file path>    -- display or change the class path\n");
        this.out.println("monitor <expression>      -- evaluate an expression each time the program stops\n");
        this.out.println("unmonitor <monitor#>      -- delete a monitor\n");
        this.out.println("read <filename>           -- read and execute a command file\n");
        this.out.println("run <class> [args]        -- start execution of a Java class");
        this.out.println("run                       -- re-execute last class run");
        this.out.println("load <class> [args]       -- start execution of a Java class, initially suspended");
        this.out.println("load                      -- re-execute last class run, initially suspended");
        this.out.println("attach <portname>         -- debug existing process\n");
        this.out.println("detach                    -- detach from debuggee process\n");
        this.out.println("kill <thread(group)>      -- kill a thread or threadgroup\n");
        this.out.println("!!                        -- repeat last command");
        this.out.println("help (or ?)               -- list commands");
        this.out.println("exit (or quit)            -- exit debugger");
    }

    public void executeCommand(String command) {
        block52: {
            this.out = this.env.getOutputSink();
            if (this.echo) {
                this.out.println(">>> " + command);
            }
            StringTokenizer t = new StringTokenizer(command);
            try {
                String cmd;
                if (t.hasMoreTokens()) {
                    this.lastCommand = cmd = t.nextToken().toLowerCase();
                } else {
                    cmd = this.lastCommand;
                }
                if (cmd.equals("print")) {
                    this.commandPrint(t, false);
                    break block52;
                }
                if (cmd.equals("eval")) {
                    this.commandPrint(t, false);
                    break block52;
                }
                if (cmd.equals("dump")) {
                    this.commandPrint(t, true);
                    break block52;
                }
                if (cmd.equals("locals")) {
                    this.commandLocals();
                    break block52;
                }
                if (cmd.equals("classes")) {
                    this.commandClasses();
                    break block52;
                }
                if (cmd.equals("methods")) {
                    this.commandMethods(t);
                    break block52;
                }
                if (cmd.equals("threads")) {
                    this.commandThreads(t);
                    break block52;
                }
                if (cmd.equals("thread")) {
                    this.commandThread(t);
                    break block52;
                }
                if (cmd.equals("suspend")) {
                    this.commandSuspend(t);
                    break block52;
                }
                if (cmd.equals("resume")) {
                    this.commandResume(t);
                    break block52;
                }
                if (cmd.equals("cont")) {
                    this.commandCont();
                    break block52;
                }
                if (cmd.equals("threadgroups")) {
                    this.commandThreadGroups();
                    break block52;
                }
                if (cmd.equals("threadgroup")) {
                    this.commandThreadGroup(t);
                    break block52;
                }
                if (cmd.equals("run")) {
                    this.commandRun(t);
                    break block52;
                }
                if (cmd.equals("load")) {
                    this.commandLoad(t);
                    break block52;
                }
                if (cmd.equals("connect")) {
                    this.commandConnect(t);
                    break block52;
                }
                if (cmd.equals("attach")) {
                    this.commandAttach(t);
                    break block52;
                }
                if (cmd.equals("detach")) {
                    this.commandDetach(t);
                    break block52;
                }
                if (cmd.equals("interrupt")) {
                    this.commandInterrupt(t);
                    break block52;
                }
                if (cmd.equals("step")) {
                    this.commandStep(t);
                    break block52;
                }
                if (cmd.equals("stepi")) {
                    this.commandStepi();
                    break block52;
                }
                if (cmd.equals("next")) {
                    this.commandNext();
                    break block52;
                }
                if (cmd.equals("nexti")) {
                    this.commandNexti();
                    break block52;
                }
                if (cmd.equals("kill")) {
                    this.commandKill(t);
                    break block52;
                }
                if (cmd.equals("where")) {
                    this.commandWhere(t, false);
                    break block52;
                }
                if (cmd.equals("wherei")) {
                    this.commandWhere(t, true);
                    break block52;
                }
                if (cmd.equals("up")) {
                    this.commandUp(t);
                    break block52;
                }
                if (cmd.equals("down")) {
                    this.commandDown(t);
                    break block52;
                }
                if (cmd.equals("frame")) {
                    this.commandFrame(t);
                    break block52;
                }
                if (cmd.equals("stop")) {
                    this.commandStop(t);
                    break block52;
                }
                if (cmd.equals("clear")) {
                    this.commandClear(t);
                    break block52;
                }
                if (cmd.equals("list")) {
                    this.commandList(t);
                    break block52;
                }
                if (cmd.equals("use")) {
                    this.commandUse(t);
                    break block52;
                }
                if (cmd.equals("sourcepath")) {
                    this.commandSourcepath(t);
                    break block52;
                }
                if (cmd.equals("classpath")) {
                    this.commandClasspath(t);
                    break block52;
                }
                if (cmd.equals("monitor")) {
                    this.commandMonitor(t);
                    break block52;
                }
                if (cmd.equals("unmonitor")) {
                    this.commandUnmonitor(t);
                    break block52;
                }
                if (cmd.equals("view")) {
                    this.commandView(t);
                    break block52;
                }
                if (cmd.equals("help") || cmd.equals("?")) {
                    this.help();
                    break block52;
                }
                if (cmd.equals("quit") || cmd.equals("exit")) {
                    try {
                        this.runtime.detach();
                    }
                    catch (NoSessionException e) {
                        // empty catch block
                    }
                    this.env.terminate();
                    break block52;
                }
                if (t.hasMoreTokens()) {
                    try {
                        int repeat = Integer.parseInt(cmd);
                        String subcom = t.nextToken("");
                        while (repeat-- > 0) {
                            this.executeCommand(subcom);
                        }
                        return;
                    }
                    catch (NumberFormatException exc) {
                        // empty catch block
                    }
                }
                this.out.println("huh? Try help...");
                this.out.flush();
            }
            catch (NoSessionException e) {
                this.out.println("There is no currently attached VM session.");
                this.out.flush();
            }
            catch (Exception e) {
                this.out.println("Internal exception: " + e.toString());
                this.out.flush();
                System.out.println("JDB internal exception: " + e.toString());
                e.printStackTrace();
            }
        }
        this.out.show();
    }
}

