/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.event;

import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.event.WatchpointEvent;
import com.sun.tools.example.debug.event.AccessWatchpointEventSet;
import com.sun.tools.example.debug.event.ClassPrepareEventSet;
import com.sun.tools.example.debug.event.ClassUnloadEventSet;
import com.sun.tools.example.debug.event.ExceptionEventSet;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.event.LocationTriggerEventSet;
import com.sun.tools.example.debug.event.ModificationWatchpointEventSet;
import com.sun.tools.example.debug.event.ThreadDeathEventSet;
import com.sun.tools.example.debug.event.ThreadStartEventSet;
import com.sun.tools.example.debug.event.VMDeathEventSet;
import com.sun.tools.example.debug.event.VMDisconnectEventSet;
import com.sun.tools.example.debug.event.VMStartEventSet;
import java.util.Collection;
import java.util.EventObject;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEventSet
extends EventObject
implements EventSet {
    private final EventSet jdiEventSet;
    final Event oneEvent;

    AbstractEventSet(EventSet jdiEventSet) {
        super(jdiEventSet.virtualMachine());
        this.jdiEventSet = jdiEventSet;
        this.oneEvent = this.eventIterator().nextEvent();
    }

    public static AbstractEventSet toSpecificEventSet(EventSet jdiEventSet) {
        Event evt = jdiEventSet.eventIterator().nextEvent();
        if (evt instanceof LocatableEvent) {
            if (evt instanceof ExceptionEvent) {
                return new ExceptionEventSet(jdiEventSet);
            }
            if (evt instanceof WatchpointEvent) {
                if (evt instanceof AccessWatchpointEvent) {
                    return new AccessWatchpointEventSet(jdiEventSet);
                }
                return new ModificationWatchpointEventSet(jdiEventSet);
            }
            return new LocationTriggerEventSet(jdiEventSet);
        }
        if (evt instanceof ClassPrepareEvent) {
            return new ClassPrepareEventSet(jdiEventSet);
        }
        if (evt instanceof ClassUnloadEvent) {
            return new ClassUnloadEventSet(jdiEventSet);
        }
        if (evt instanceof ThreadDeathEvent) {
            return new ThreadDeathEventSet(jdiEventSet);
        }
        if (evt instanceof ThreadStartEvent) {
            return new ThreadStartEventSet(jdiEventSet);
        }
        if (evt instanceof VMDeathEvent) {
            return new VMDeathEventSet(jdiEventSet);
        }
        if (evt instanceof VMDisconnectEvent) {
            return new VMDisconnectEventSet(jdiEventSet);
        }
        if (evt instanceof VMStartEvent) {
            return new VMStartEventSet(jdiEventSet);
        }
        throw new IllegalArgumentException("Unknown event " + evt);
    }

    public abstract void notify(JDIListener var1);

    @Override
    public VirtualMachine virtualMachine() {
        return this.jdiEventSet.virtualMachine();
    }

    public VirtualMachine getVirtualMachine() {
        return this.jdiEventSet.virtualMachine();
    }

    public int getSuspendPolicy() {
        return this.jdiEventSet.suspendPolicy();
    }

    @Override
    public void resume() {
        this.jdiEventSet.resume();
    }

    @Override
    public int suspendPolicy() {
        return this.jdiEventSet.suspendPolicy();
    }

    public boolean suspendedAll() {
        return this.jdiEventSet.suspendPolicy() == 2;
    }

    public boolean suspendedEventThread() {
        return this.jdiEventSet.suspendPolicy() == 1;
    }

    public boolean suspendedNone() {
        return this.jdiEventSet.suspendPolicy() == 0;
    }

    @Override
    public EventIterator eventIterator() {
        return this.jdiEventSet.eventIterator();
    }

    @Override
    public int size() {
        return this.jdiEventSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.jdiEventSet.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.jdiEventSet.contains(o);
    }

    @Override
    public Iterator<Event> iterator() {
        return this.jdiEventSet.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.jdiEventSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.jdiEventSet.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.jdiEventSet.containsAll(c);
    }

    @Override
    public boolean add(Event e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Event> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }
}

