/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;

public class Utils {
    public static String getStatus(ThreadReference thr) {
        String result;
        int status = thr.status();
        switch (status) {
            case -1: {
                result = "unknown status";
                break;
            }
            case 0: {
                result = "zombie";
                break;
            }
            case 1: {
                result = "running";
                break;
            }
            case 2: {
                result = "sleeping";
                break;
            }
            case 3: {
                result = "waiting to acquire a monitor lock";
                break;
            }
            case 4: {
                result = "waiting on a condition";
                break;
            }
            default: {
                result = "<invalid thread status>";
            }
        }
        if (thr.isSuspended()) {
            result = result + " (suspended)";
        }
        return result;
    }

    public static String description(ObjectReference ref) {
        ReferenceType clazz = ref.referenceType();
        long id = ref.uniqueID();
        if (clazz == null) {
            return Utils.toHex(id);
        }
        return "(" + clazz.name() + ")" + Utils.toHex(id);
    }

    public static String toHex(long n) {
        char[] s1 = new char[16];
        char[] s2 = new char[18];
        int i = 0;
        do {
            long d = n & 0xFL;
            s1[i++] = (char)(d < 10L ? 48L + d : 97L + d - 10L);
        } while ((n >>>= 4) > 0L);
        s2[0] = 48;
        s2[1] = 120;
        int j = 2;
        while (--i >= 0) {
            s2[j++] = s1[i];
        }
        return new String(s2, 0, j);
    }

    public static long fromHex(String hexStr) {
        String str;
        String string = str = hexStr.startsWith("0x") ? hexStr.substring(2).toLowerCase() : hexStr.toLowerCase();
        if (hexStr.length() == 0) {
            throw new NumberFormatException();
        }
        long ret = 0L;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') {
                ret = ret * 16L + (long)(c - 48);
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                ret = ret * 16L + (long)(c - 97 + 10);
                continue;
            }
            throw new NumberFormatException();
        }
        return ret;
    }

    public static String locationString(Location loc) {
        return loc.declaringType().name() + "." + loc.method().name() + "(), line=" + loc.lineNumber();
    }

    public static boolean isValidMethodName(String s) {
        return Utils.isJavaIdentifier(s) || s.equals("<init>") || s.equals("<clinit>");
    }

    public static boolean isJavaIdentifier(String s) {
        if (s.length() == 0) {
            return false;
        }
        int cp = s.codePointAt(0);
        if (!Character.isJavaIdentifierStart(cp)) {
            return false;
        }
        for (int i = Character.charCount(cp); i < s.length(); i += Character.charCount(cp)) {
            cp = s.codePointAt(i);
            if (Character.isJavaIdentifierPart(cp)) continue;
            return false;
        }
        return true;
    }
}

