/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;

public class ThreadInfo {
    private ThreadReference thread;
    private int status;
    private int frameCount;
    Object userObject;
    private boolean interrupted = false;

    private void assureInterrupted() throws VMNotInterruptedException {
        if (!this.interrupted) {
            throw new VMNotInterruptedException();
        }
    }

    ThreadInfo(ThreadReference thread) {
        this.thread = thread;
        this.frameCount = -1;
    }

    public ThreadReference thread() {
        return this.thread;
    }

    public int getStatus() throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        return this.status;
    }

    public int getFrameCount() throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        return this.frameCount;
    }

    public StackFrame getFrame(int index) throws VMNotInterruptedException {
        this.assureInterrupted();
        this.update();
        try {
            return this.thread.frame(index);
        }
        catch (IncompatibleThreadStateException e) {
            this.interrupted = false;
            throw new VMNotInterruptedException();
        }
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object obj) {
        this.userObject = obj;
    }

    void update() throws VMNotInterruptedException {
        if (this.frameCount == -1) {
            try {
                this.status = this.thread.status();
                this.frameCount = this.thread.frameCount();
            }
            catch (IncompatibleThreadStateException e) {
                this.interrupted = false;
                throw new VMNotInterruptedException();
            }
        }
    }

    void validate() {
        this.interrupted = true;
    }

    void invalidate() {
        this.interrupted = false;
        this.frameCount = -1;
        this.status = -1;
    }
}

