/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.tools.example.debug.bdi.AmbiguousMethodException;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.MalformedMemberNameException;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodBreakpointSpec
extends BreakpointSpec {
    String methodId;
    List<String> methodArgs;

    MethodBreakpointSpec(EventRequestSpecList specs, ReferenceTypeSpec refSpec, String methodId, List<String> methodArgs) {
        super(specs, refSpec);
        this.methodId = methodId;
        this.methodArgs = methodArgs;
    }

    @Override
    void resolve(ReferenceType refType) throws MalformedMemberNameException, AmbiguousMethodException, InvalidTypeException, NoSuchMethodException, NoSessionException {
        if (!this.isValidMethodName(this.methodId)) {
            throw new MalformedMemberNameException(this.methodId);
        }
        if (!(refType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Location location = this.location((ClassType)refType);
        this.setRequest(refType.virtualMachine().eventRequestManager().createBreakpointRequest(location));
    }

    private Location location(ClassType clazz) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        Method method = this.findMatchingMethod(clazz);
        Location location = method.location();
        return location;
    }

    public String methodName() {
        return this.methodId;
    }

    public List<String> methodArgs() {
        return this.methodArgs;
    }

    public int hashCode() {
        return ((Object)this.refSpec).hashCode() + (this.methodId != null ? this.methodId.hashCode() : 0) + (this.methodArgs != null ? ((Object)this.methodArgs).hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (obj instanceof MethodBreakpointSpec) {
            MethodBreakpointSpec breakpoint = (MethodBreakpointSpec)obj;
            return this.methodId.equals(breakpoint.methodId) && ((Object)this.methodArgs).equals(breakpoint.methodArgs) && ((Object)this.refSpec).equals(breakpoint.refSpec);
        }
        return false;
    }

    @Override
    public String errorMessageFor(Exception e) {
        if (e instanceof AmbiguousMethodException) {
            return "Method " + this.methodName() + " is overloaded; specify arguments";
        }
        if (e instanceof NoSuchMethodException) {
            return "No method " + this.methodName() + " in " + this.refSpec;
        }
        if (e instanceof InvalidTypeException) {
            return "Breakpoints can be located only in classes. " + this.refSpec + " is an interface or array";
        }
        return super.errorMessageFor(e);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("breakpoint ");
        buffer.append(this.refSpec.toString());
        buffer.append('.');
        buffer.append(this.methodId);
        if (this.methodArgs != null) {
            boolean first = true;
            buffer.append('(');
            for (String name : this.methodArgs) {
                if (!first) {
                    buffer.append(',');
                }
                buffer.append(name);
                first = false;
            }
            buffer.append(")");
        }
        buffer.append(" (");
        buffer.append(this.getStatusString());
        buffer.append(')');
        return buffer.toString();
    }

    private boolean isValidMethodName(String s) {
        return this.isJavaIdentifier(s) || s.equals("<init>") || s.equals("<clinit>");
    }

    private boolean compareArgTypes(Method method, List<String> nameList) {
        List<String> argTypeNames = method.argumentTypeNames();
        if (argTypeNames.size() != nameList.size()) {
            return false;
        }
        int nTypes = argTypeNames.size();
        for (int i = 0; i < nTypes; ++i) {
            String comp2;
            String comp1 = argTypeNames.get(i);
            if (comp1.equals(comp2 = nameList.get(i))) continue;
            if (i != nTypes - 1 || !method.isVarArgs() || !comp2.endsWith("...")) {
                return false;
            }
            int comp1Length = comp1.length();
            if (comp1Length + 1 != comp2.length()) {
                return false;
            }
            return comp1.regionMatches(0, comp2, 0, comp1Length - 2);
        }
        return true;
    }

    private VirtualMachine vm() {
        return this.request.virtualMachine();
    }

    private String normalizeArgTypeName(String name) throws NoSessionException {
        char c;
        int i = 0;
        StringBuffer typePart = new StringBuffer();
        StringBuffer arrayPart = new StringBuffer();
        name = name.trim();
        int nameLength = name.length();
        boolean isVarArgs = name.endsWith("...");
        if (isVarArgs) {
            nameLength -= 3;
        }
        while (i < nameLength && !Character.isWhitespace(c = name.charAt(i)) && c != '[') {
            typePart.append(c);
            ++i;
        }
        while (i < nameLength) {
            c = name.charAt(i);
            if (c == '[' || c == ']') {
                arrayPart.append(c);
            } else if (!Character.isWhitespace(c)) {
                throw new IllegalArgumentException("Invalid argument type name");
            }
            ++i;
        }
        name = typePart.toString();
        if (name.indexOf(46) == -1 || name.startsWith("*.")) {
            try {
                List<ReferenceType> refs = this.specs.runtime.findClassesMatchingPattern(name);
                if (refs.size() > 0) {
                    name = refs.get(0).name();
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        name = name + arrayPart.toString();
        if (isVarArgs) {
            name = name + "...";
        }
        return name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method findMatchingMethod(ClassType clazz) throws AmbiguousMethodException, NoSuchMethodException, NoSessionException {
        ArrayList<String> argTypeNames = null;
        if (this.methodArgs() != null) {
            argTypeNames = new ArrayList<String>(this.methodArgs().size());
            for (String name : this.methodArgs()) {
                name = this.normalizeArgTypeName(name);
                argTypeNames.add(name);
            }
        }
        Method firstMatch = null;
        Method exactMatch = null;
        int matchCount = 0;
        for (Method candidate : clazz.methods()) {
            if (!candidate.name().equals(this.methodName())) continue;
            if (++matchCount == 1) {
                firstMatch = candidate;
            }
            if (argTypeNames == null || !this.compareArgTypes(candidate, argTypeNames)) continue;
            exactMatch = candidate;
            break;
        }
        Method method = null;
        if (exactMatch != null) {
            return exactMatch;
        }
        if (argTypeNames != null) throw new NoSuchMethodException(this.methodName());
        if (matchCount <= 0) throw new NoSuchMethodException(this.methodName());
        if (matchCount != 1) throw new AmbiguousMethodException();
        return firstMatch;
    }
}

