/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.LineNotFoundException;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import java.util.List;

public class LineBreakpointSpec
extends BreakpointSpec {
    int lineNumber;

    LineBreakpointSpec(EventRequestSpecList specs, ReferenceTypeSpec refSpec, int lineNumber) {
        super(specs, refSpec);
        this.lineNumber = lineNumber;
    }

    void resolve(ReferenceType refType) throws InvalidTypeException, LineNotFoundException {
        if (!(refType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Location location = this.location((ClassType)refType);
        this.setRequest(refType.virtualMachine().eventRequestManager().createBreakpointRequest(location));
    }

    private Location location(ClassType clazz) throws LineNotFoundException {
        Location location = null;
        try {
            List<Location> locs = clazz.locationsOfLine(this.lineNumber());
            if (locs.size() == 0) {
                throw new LineNotFoundException();
            }
            location = locs.get(0);
            if (location.method() == null) {
                throw new LineNotFoundException();
            }
        }
        catch (AbsentInformationException e) {
            throw new LineNotFoundException();
        }
        return location;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public int hashCode() {
        return ((Object)this.refSpec).hashCode() + this.lineNumber;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LineBreakpointSpec) {
            LineBreakpointSpec breakpoint = (LineBreakpointSpec)obj;
            return ((Object)this.refSpec).equals(breakpoint.refSpec) && this.lineNumber == breakpoint.lineNumber;
        }
        return false;
    }

    public String errorMessageFor(Exception e) {
        if (e instanceof LineNotFoundException) {
            return "No code at line " + this.lineNumber() + " in " + this.refSpec;
        }
        if (e instanceof InvalidTypeException) {
            return "Breakpoints can be located only in classes. " + this.refSpec + " is an interface or array";
        }
        return super.errorMessageFor(e);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("breakpoint ");
        buffer.append(this.refSpec.toString());
        buffer.append(':');
        buffer.append(this.lineNumber);
        buffer.append(" (");
        buffer.append(this.getStatusString());
        buffer.append(')');
        return buffer.toString();
    }
}

