/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.ClassUnloadRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.StepRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import com.sun.tools.example.debug.bdi.AccessWatchpointSpec;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.ChildSession;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.ExceptionSpec;
import com.sun.tools.example.debug.bdi.InputListener;
import com.sun.tools.example.debug.bdi.ModificationWatchpointSpec;
import com.sun.tools.example.debug.bdi.NoSessionException;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.Session;
import com.sun.tools.example.debug.bdi.SessionListener;
import com.sun.tools.example.debug.bdi.SpecListener;
import com.sun.tools.example.debug.bdi.ThreadInfo;
import com.sun.tools.example.debug.bdi.VMLaunchFailureException;
import com.sun.tools.example.debug.bdi.VMNotInterruptedException;
import com.sun.tools.example.debug.event.JDIListener;
import com.sun.tools.example.debug.expr.ExpressionParser;
import com.sun.tools.example.debug.expr.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExecutionManager {
    private Session session;
    int traceMode = 0;
    Vector<SessionListener> sessionListeners = new Vector();
    Vector<SpecListener> specListeners = new Vector();
    Vector<JDIListener> jdiListeners = new Vector();
    private Vector<OutputListener> appEchoListeners = new Vector();
    private Vector<OutputListener> appOutputListeners = new Vector();
    private Vector<OutputListener> appErrorListeners = new Vector();
    private Vector<OutputListener> diagnosticsListeners = new Vector();
    private List<ThreadInfo> threadInfoList = new LinkedList<ThreadInfo>();
    private HashMap<ThreadReference, ThreadInfo> threadInfoMap = new HashMap();
    private Object inputLock = new Object();
    private LinkedList<String> inputBuffer = new LinkedList();
    private InputListener appInput = new InputListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getLine() {
            String line = null;
            while (line == null) {
                Object object = ExecutionManager.this.inputLock;
                synchronized (object) {
                    try {
                        while (ExecutionManager.this.inputBuffer.size() < 1) {
                            ExecutionManager.this.inputLock.wait();
                        }
                        line = (String)ExecutionManager.this.inputBuffer.removeLast();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            final String input = line;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ExecutionManager.this.echoInputLine(input);
                }
            });
            return line;
        }
    };
    private static String newline = System.getProperty("line.separator");
    private OutputListener appOutput = new OutputListener(){

        public void putString(String string) {
            Vector l = (Vector)ExecutionManager.this.appOutputListeners.clone();
            for (int i = 0; i < l.size(); ++i) {
                ((OutputListener)l.elementAt(i)).putString(string);
            }
        }
    };
    private OutputListener appError = new OutputListener(){

        public void putString(String string) {
            Vector l = (Vector)ExecutionManager.this.appErrorListeners.clone();
            for (int i = 0; i < l.size(); ++i) {
                ((OutputListener)l.elementAt(i)).putString(string);
            }
        }
    };
    private OutputListener diagnostics = new OutputListener(){

        public void putString(String string) {
            Vector l = (Vector)ExecutionManager.this.diagnosticsListeners.clone();
            for (int i = 0; i < l.size(); ++i) {
                ((OutputListener)l.elementAt(i)).putString(string);
            }
        }
    };
    private EventRequestSpecList specList = new EventRequestSpecList(this);

    public void addSessionListener(SessionListener listener) {
        this.sessionListeners.add(listener);
    }

    public void removeSessionListener(SessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    public void addSpecListener(SpecListener cl) {
        this.specListeners.add(cl);
    }

    public void removeSpecListener(SpecListener cl) {
        this.specListeners.remove(cl);
    }

    public void addJDIListener(JDIListener jl) {
        this.jdiListeners.add(jl);
    }

    public void addJDIListener(int index, JDIListener jl) {
        this.jdiListeners.add(index, jl);
    }

    public void removeJDIListener(JDIListener jl) {
        this.jdiListeners.remove(jl);
    }

    public void addApplicationEchoListener(OutputListener l) {
        this.appEchoListeners.addElement(l);
    }

    public void removeApplicationEchoListener(OutputListener l) {
        this.appEchoListeners.removeElement(l);
    }

    public void addApplicationOutputListener(OutputListener l) {
        this.appOutputListeners.addElement(l);
    }

    public void removeApplicationOutputListener(OutputListener l) {
        this.appOutputListeners.removeElement(l);
    }

    public void addApplicationErrorListener(OutputListener l) {
        this.appErrorListeners.addElement(l);
    }

    public void removeApplicationErrorListener(OutputListener l) {
        this.appErrorListeners.removeElement(l);
    }

    public void addDiagnosticsListener(OutputListener l) {
        this.diagnosticsListeners.addElement(l);
    }

    public void removeDiagnosticsListener(OutputListener l) {
        this.diagnosticsListeners.removeElement(l);
    }

    public VirtualMachine vm() {
        return this.session == null ? null : this.session.vm;
    }

    void ensureActiveSession() throws NoSessionException {
        if (this.session == null) {
            throw new NoSessionException();
        }
    }

    public EventRequestManager eventRequestManager() {
        return this.vm() == null ? null : this.vm().eventRequestManager();
    }

    public int getTraceMode(int mode) {
        return this.traceMode;
    }

    public void setTraceMode(int mode) {
        this.traceMode = mode;
        if (this.session != null) {
            this.session.setTraceMode(mode);
        }
    }

    public boolean isInterrupted() {
        return this.session.interrupted;
    }

    public List<ReferenceType> allClasses() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().allClasses();
    }

    public List<ReferenceType> findClassesByName(String name) throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().classesByName(name);
    }

    public List<ReferenceType> findClassesMatchingPattern(String pattern) throws NoSessionException {
        this.ensureActiveSession();
        ArrayList<ReferenceType> result = new ArrayList<ReferenceType>();
        if (pattern.startsWith("*.")) {
            pattern = pattern.substring(1);
            for (ReferenceType type : this.vm().allClasses()) {
                if (!type.name().endsWith(pattern)) continue;
                result.add(type);
            }
            return result;
        }
        return this.vm().classesByName(pattern);
    }

    public List<ThreadReference> allThreads() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().allThreads();
    }

    public List<ThreadGroupReference> topLevelThreadGroups() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().topLevelThreadGroups();
    }

    public ThreadGroupReference systemThreadGroup() throws NoSessionException {
        this.ensureActiveSession();
        return this.vm().topLevelThreadGroups().get(0);
    }

    public Value evaluate(final StackFrame f, String expr) throws ParseException, InvocationException, InvalidTypeException, ClassNotLoadedException, NoSessionException, IncompatibleThreadStateException {
        ExpressionParser.GetFrame frameGetter = null;
        this.ensureActiveSession();
        if (f != null) {
            frameGetter = new ExpressionParser.GetFrame(){

                public StackFrame get() {
                    return f;
                }
            };
        }
        return ExpressionParser.evaluate(expr, this.vm(), frameGetter);
    }

    public void run(boolean suspended, String vmArgs, String className, String args) throws VMLaunchFailureException {
        this.endSession();
        if (suspended) {
            ArrayList<String> argList = new ArrayList<String>(1);
            argList.add("java.lang.String[]");
            this.createMethodBreakpoint(className, "main", argList);
        }
        String cmdLine = className + " " + args;
        this.startSession(new ChildSession(this, vmArgs, cmdLine, this.appInput, this.appOutput, this.appError, this.diagnostics));
    }

    public void attach(String portName) throws VMLaunchFailureException {
        this.endSession();
        VirtualMachineManager mgr = Bootstrap.virtualMachineManager();
        AttachingConnector connector = mgr.attachingConnectors().get(0);
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get("port").setValue(portName);
        Session newSession = this.internalAttach(connector, arguments);
        if (newSession != null) {
            this.startSession(newSession);
        }
    }

    private Session internalAttach(AttachingConnector connector, Map<String, Connector.Argument> arguments) {
        try {
            VirtualMachine vm = connector.attach(arguments);
            return new Session(vm, this, this.diagnostics);
        }
        catch (IOException ioe) {
            this.diagnostics.putString("\n Unable to attach to target VM: " + ioe.getMessage());
        }
        catch (IllegalConnectorArgumentsException icae) {
            this.diagnostics.putString("\n Invalid connector arguments: " + icae.getMessage());
        }
        return null;
    }

    private Session internalListen(ListeningConnector connector, Map<String, Connector.Argument> arguments) {
        try {
            VirtualMachine vm = connector.accept(arguments);
            return new Session(vm, this, this.diagnostics);
        }
        catch (IOException ioe) {
            this.diagnostics.putString("\n Unable to accept connection to target VM: " + ioe.getMessage());
        }
        catch (IllegalConnectorArgumentsException icae) {
            this.diagnostics.putString("\n Invalid connector arguments: " + icae.getMessage());
        }
        return null;
    }

    public boolean explictStart(Connector connector, Map<String, Connector.Argument> arguments) throws VMLaunchFailureException {
        Session newSession = null;
        this.endSession();
        if (connector instanceof LaunchingConnector) {
            newSession = new ChildSession(this, (LaunchingConnector)connector, arguments, this.appInput, this.appOutput, this.appError, this.diagnostics);
        } else if (connector instanceof AttachingConnector) {
            newSession = this.internalAttach((AttachingConnector)connector, arguments);
        } else if (connector instanceof ListeningConnector) {
            newSession = this.internalListen((ListeningConnector)connector, arguments);
        } else {
            this.diagnostics.putString("\n Unknown connector: " + connector);
        }
        if (newSession != null) {
            this.startSession(newSession);
        }
        return newSession != null;
    }

    public void detach() throws NoSessionException {
        this.ensureActiveSession();
        this.endSession();
    }

    private void startSession(Session s) throws VMLaunchFailureException {
        if (!s.attach()) {
            throw new VMLaunchFailureException();
        }
        this.session = s;
        EventRequestManager em = this.vm().eventRequestManager();
        ClassPrepareRequest classPrepareRequest = em.createClassPrepareRequest();
        classPrepareRequest.setSuspendPolicy(2);
        classPrepareRequest.enable();
        ClassUnloadRequest classUnloadRequest = em.createClassUnloadRequest();
        classUnloadRequest.setSuspendPolicy(0);
        classUnloadRequest.enable();
        ThreadStartRequest threadStartRequest = em.createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = em.createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        threadDeathRequest.enable();
        ExceptionRequest exceptionRequest = em.createExceptionRequest(null, false, true);
        exceptionRequest.setSuspendPolicy(2);
        exceptionRequest.enable();
        this.validateThreadInfo();
        this.session.interrupted = true;
        this.notifySessionStart();
    }

    void endSession() {
        if (this.session != null) {
            this.session.detach();
            this.session = null;
            this.invalidateThreadInfo();
            this.notifySessionDeath();
        }
    }

    public void interrupt() throws NoSessionException {
        this.ensureActiveSession();
        this.vm().suspend();
        this.validateThreadInfo();
        this.session.interrupted = true;
        this.notifyInterrupted();
    }

    public void go() throws NoSessionException, VMNotInterruptedException {
        this.ensureActiveSession();
        this.invalidateThreadInfo();
        this.session.interrupted = false;
        this.notifyContinued();
        this.vm().resume();
    }

    void clearPreviousStep(ThreadReference thread) {
        EventRequestManager mgr = this.vm().eventRequestManager();
        for (StepRequest request : mgr.stepRequests()) {
            if (!request.thread().equals(thread)) continue;
            mgr.deleteEventRequest(request);
            break;
        }
    }

    private void generalStep(ThreadReference thread, int size, int depth) throws NoSessionException {
        this.ensureActiveSession();
        this.invalidateThreadInfo();
        this.session.interrupted = false;
        this.notifyContinued();
        this.clearPreviousStep(thread);
        EventRequestManager reqMgr = this.vm().eventRequestManager();
        StepRequest request = reqMgr.createStepRequest(thread, size, depth);
        request.addCountFilter(1);
        request.enable();
        this.vm().resume();
    }

    public void stepIntoInstruction(ThreadReference thread) throws NoSessionException {
        this.generalStep(thread, -1, 1);
    }

    public void stepOverInstruction(ThreadReference thread) throws NoSessionException {
        this.generalStep(thread, -1, 2);
    }

    public void stepIntoLine(ThreadReference thread) throws NoSessionException, AbsentInformationException {
        this.generalStep(thread, -2, 1);
    }

    public void stepOverLine(ThreadReference thread) throws NoSessionException, AbsentInformationException {
        this.generalStep(thread, -2, 2);
    }

    public void stepOut(ThreadReference thread) throws NoSessionException {
        this.generalStep(thread, -1, 3);
    }

    public void suspendThread(ThreadReference thread) throws NoSessionException {
        this.ensureActiveSession();
        thread.suspend();
    }

    public void resumeThread(ThreadReference thread) throws NoSessionException {
        this.ensureActiveSession();
        thread.resume();
    }

    public void stopThread(ThreadReference thread) throws NoSessionException {
        this.ensureActiveSession();
    }

    public ThreadInfo threadInfo(ThreadReference thread) {
        if (this.session == null || thread == null) {
            return null;
        }
        ThreadInfo info = this.threadInfoMap.get(thread);
        if (info == null) {
            info = new ThreadInfo(thread);
            if (this.session.interrupted) {
                info.validate();
            }
            this.threadInfoList.add(info);
            this.threadInfoMap.put(thread, info);
        }
        return info;
    }

    void validateThreadInfo() {
        this.session.interrupted = true;
        for (ThreadInfo threadInfo : this.threadInfoList) {
            threadInfo.validate();
        }
    }

    private void invalidateThreadInfo() {
        if (this.session != null) {
            this.session.interrupted = false;
            for (ThreadInfo threadInfo : this.threadInfoList) {
                threadInfo.invalidate();
            }
        }
    }

    void removeThreadInfo(ThreadReference thread) {
        ThreadInfo info = this.threadInfoMap.get(thread);
        if (info != null) {
            info.invalidate();
            this.threadInfoMap.remove(thread);
            this.threadInfoList.remove(info);
        }
    }

    private void notifyInterrupted() {
        Vector l = (Vector)this.sessionListeners.clone();
        EventObject evt = new EventObject(this);
        for (int i = 0; i < l.size(); ++i) {
            ((SessionListener)l.elementAt(i)).sessionInterrupt(evt);
        }
    }

    private void notifyContinued() {
        Vector l = (Vector)this.sessionListeners.clone();
        EventObject evt = new EventObject(this);
        for (int i = 0; i < l.size(); ++i) {
            ((SessionListener)l.elementAt(i)).sessionContinue(evt);
        }
    }

    private void notifySessionStart() {
        Vector l = (Vector)this.sessionListeners.clone();
        EventObject evt = new EventObject(this);
        for (int i = 0; i < l.size(); ++i) {
            ((SessionListener)l.elementAt(i)).sessionStart(evt);
        }
    }

    private void notifySessionDeath() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetInputBuffer() {
        Object object = this.inputLock;
        synchronized (object) {
            this.inputBuffer = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLineToApplication(String line) {
        Object object = this.inputLock;
        synchronized (object) {
            this.inputBuffer.addFirst(line);
            this.inputLock.notifyAll();
        }
    }

    private void echoInputLine(String line) {
        Vector l = (Vector)this.appEchoListeners.clone();
        for (int i = 0; i < l.size(); ++i) {
            OutputListener ol = (OutputListener)l.elementAt(i);
            ol.putString(line);
            ol.putString(newline);
        }
    }

    public BreakpointSpec createSourceLineBreakpoint(String sourceName, int line) {
        return this.specList.createSourceLineBreakpoint(sourceName, line);
    }

    public BreakpointSpec createClassLineBreakpoint(String classPattern, int line) {
        return this.specList.createClassLineBreakpoint(classPattern, line);
    }

    public BreakpointSpec createMethodBreakpoint(String classPattern, String methodId, List<String> methodArgs) {
        return this.specList.createMethodBreakpoint(classPattern, methodId, methodArgs);
    }

    public ExceptionSpec createExceptionIntercept(String classPattern, boolean notifyCaught, boolean notifyUncaught) {
        return this.specList.createExceptionIntercept(classPattern, notifyCaught, notifyUncaught);
    }

    public AccessWatchpointSpec createAccessWatchpoint(String classPattern, String fieldId) {
        return this.specList.createAccessWatchpoint(classPattern, fieldId);
    }

    public ModificationWatchpointSpec createModificationWatchpoint(String classPattern, String fieldId) {
        return this.specList.createModificationWatchpoint(classPattern, fieldId);
    }

    public void delete(EventRequestSpec spec) {
        this.specList.delete(spec);
    }

    void resolve(ReferenceType refType) {
        this.specList.resolve(refType);
    }

    public void install(EventRequestSpec spec) {
        this.specList.install(spec, this.vm());
    }

    public List<EventRequestSpec> eventRequestSpecs() {
        return this.specList.eventRequestSpecs();
    }
}

