/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequest;
import com.sun.tools.example.debug.bdi.AccessWatchpointSpec;
import com.sun.tools.example.debug.bdi.BreakpointSpec;
import com.sun.tools.example.debug.bdi.EventRequestSpec;
import com.sun.tools.example.debug.bdi.ExceptionSpec;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.LineBreakpointSpec;
import com.sun.tools.example.debug.bdi.MethodBreakpointSpec;
import com.sun.tools.example.debug.bdi.ModificationWatchpointSpec;
import com.sun.tools.example.debug.bdi.PatternReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SourceNameReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.SpecErrorEvent;
import com.sun.tools.example.debug.bdi.SpecEvent;
import com.sun.tools.example.debug.bdi.SpecListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EventRequestSpecList {
    private List<EventRequestSpec> eventRequestSpecs = Collections.synchronizedList(new ArrayList());
    final ExecutionManager runtime;

    EventRequestSpecList(ExecutionManager runtime) {
        this.runtime = runtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(ReferenceType refType) {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            for (EventRequestSpec spec : this.eventRequestSpecs) {
                spec.attemptResolve(refType);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void install(EventRequestSpec ers, VirtualMachine vm) {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.add(ers);
        }
        if (vm != null) {
            ers.attemptImmediateResolve(vm);
        }
    }

    BreakpointSpec createClassLineBreakpoint(String classPattern, int line) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new LineBreakpointSpec(this, refSpec, line);
    }

    BreakpointSpec createSourceLineBreakpoint(String sourceName, int line) {
        SourceNameReferenceTypeSpec refSpec = new SourceNameReferenceTypeSpec(sourceName, line);
        return new LineBreakpointSpec(this, refSpec, line);
    }

    BreakpointSpec createMethodBreakpoint(String classPattern, String methodId, List<String> methodArgs) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new MethodBreakpointSpec(this, refSpec, methodId, methodArgs);
    }

    ExceptionSpec createExceptionIntercept(String classPattern, boolean notifyCaught, boolean notifyUncaught) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ExceptionSpec(this, refSpec, notifyCaught, notifyUncaught);
    }

    AccessWatchpointSpec createAccessWatchpoint(String classPattern, String fieldId) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new AccessWatchpointSpec(this, refSpec, fieldId);
    }

    ModificationWatchpointSpec createModificationWatchpoint(String classPattern, String fieldId) {
        PatternReferenceTypeSpec refSpec = new PatternReferenceTypeSpec(classPattern);
        return new ModificationWatchpointSpec(this, refSpec, fieldId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(EventRequestSpec ers) {
        EventRequest request = ers.getEventRequest();
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            this.eventRequestSpecs.remove(ers);
        }
        if (request != null) {
            request.virtualMachine().eventRequestManager().deleteEventRequest(request);
        }
        this.notifyDeleted(ers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<EventRequestSpec> eventRequestSpecs() {
        List<EventRequestSpec> list = this.eventRequestSpecs;
        synchronized (list) {
            return new ArrayList<EventRequestSpec>(this.eventRequestSpecs);
        }
    }

    private Vector<SpecListener> specListeners() {
        return (Vector)this.runtime.specListeners.clone();
    }

    void notifySet(EventRequestSpec spec) {
        Vector<SpecListener> l = this.specListeners();
        SpecEvent evt = new SpecEvent(spec);
        for (int i = 0; i < l.size(); ++i) {
            spec.notifySet(l.elementAt(i), evt);
        }
    }

    void notifyDeferred(EventRequestSpec spec) {
        Vector<SpecListener> l = this.specListeners();
        SpecEvent evt = new SpecEvent(spec);
        for (int i = 0; i < l.size(); ++i) {
            spec.notifyDeferred(l.elementAt(i), evt);
        }
    }

    void notifyDeleted(EventRequestSpec spec) {
        Vector<SpecListener> l = this.specListeners();
        SpecEvent evt = new SpecEvent(spec);
        for (int i = 0; i < l.size(); ++i) {
            spec.notifyDeleted(l.elementAt(i), evt);
        }
    }

    void notifyResolved(EventRequestSpec spec) {
        Vector<SpecListener> l = this.specListeners();
        SpecEvent evt = new SpecEvent(spec);
        for (int i = 0; i < l.size(); ++i) {
            spec.notifyResolved(l.elementAt(i), evt);
        }
    }

    void notifyError(EventRequestSpec spec, Exception exc) {
        Vector<SpecListener> l = this.specListeners();
        SpecErrorEvent evt = new SpecErrorEvent(spec, exc);
        for (int i = 0; i < l.size(); ++i) {
            spec.notifyError(l.elementAt(i), evt);
        }
    }
}

