/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.tools.example.debug.bdi.ExecutionManager;
import com.sun.tools.example.debug.bdi.InputListener;
import com.sun.tools.example.debug.bdi.OutputListener;
import com.sun.tools.example.debug.bdi.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ChildSession
extends Session {
    private Process process;
    private PrintWriter in;
    private BufferedReader out;
    private BufferedReader err;
    private InputWriter inputWriter;
    private OutputReader outputReader;
    private OutputReader errorReader;
    private InputListener input;
    private OutputListener output;
    private OutputListener error;

    public ChildSession(ExecutionManager runtime, String userVMArgs, String cmdLine, InputListener input, OutputListener output, OutputListener error, OutputListener diagnostics) {
        this(runtime, ChildSession.getVM(diagnostics, userVMArgs, cmdLine), input, output, error, diagnostics);
    }

    public ChildSession(ExecutionManager runtime, LaunchingConnector connector, Map<String, Connector.Argument> arguments, InputListener input, OutputListener output, OutputListener error, OutputListener diagnostics) {
        this(runtime, ChildSession.generalGetVM(diagnostics, connector, arguments), input, output, error, diagnostics);
    }

    private ChildSession(ExecutionManager runtime, VirtualMachine vm, InputListener input, OutputListener output, OutputListener error, OutputListener diagnostics) {
        super(vm, runtime, diagnostics);
        this.input = input;
        this.output = output;
        this.error = error;
    }

    @Override
    public boolean attach() {
        if (!this.connectToVMProcess()) {
            this.diagnostics.putString("Could not launch VM");
            return false;
        }
        OutputReader outputReader = new OutputReader("output reader", "output", this.out, this.output, this.diagnostics);
        outputReader.setPriority(9);
        outputReader.start();
        OutputReader errorReader = new OutputReader("error reader", "error", this.err, this.error, this.diagnostics);
        errorReader.setPriority(9);
        errorReader.start();
        InputWriter inputWriter = new InputWriter("input writer", this.in, this.input);
        inputWriter.setPriority(9);
        inputWriter.start();
        if (!super.attach()) {
            if (this.process != null) {
                this.process.destroy();
                this.process = null;
            }
            return false;
        }
        return true;
    }

    @Override
    public void detach() {
        super.detach();
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
    }

    private static void dumpStream(OutputListener diagnostics, InputStream stream) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(stream));
        while ((line = in.readLine()) != null) {
            diagnostics.putString(line);
        }
    }

    private static void dumpFailedLaunchInfo(OutputListener diagnostics, Process process) {
        try {
            ChildSession.dumpStream(diagnostics, process.getErrorStream());
            ChildSession.dumpStream(diagnostics, process.getInputStream());
        }
        catch (IOException e) {
            diagnostics.putString("Unable to display process output: " + e.getMessage());
        }
    }

    private static VirtualMachine getVM(OutputListener diagnostics, String userVMArgs, String cmdLine) {
        VirtualMachineManager manager = Bootstrap.virtualMachineManager();
        LaunchingConnector connector = manager.defaultConnector();
        Map<String, Connector.Argument> arguments = connector.defaultArguments();
        arguments.get("options").setValue(userVMArgs);
        arguments.get("main").setValue(cmdLine);
        return ChildSession.generalGetVM(diagnostics, connector, arguments);
    }

    private static VirtualMachine generalGetVM(OutputListener diagnostics, LaunchingConnector connector, Map<String, Connector.Argument> arguments) {
        VirtualMachine vm = null;
        try {
            diagnostics.putString("Starting child.");
            vm = connector.launch(arguments);
        }
        catch (IOException ioe) {
            diagnostics.putString("Unable to start child: " + ioe.getMessage());
        }
        catch (IllegalConnectorArgumentsException icae) {
            diagnostics.putString("Unable to start child: " + icae.getMessage());
        }
        catch (VMStartException vmse) {
            diagnostics.putString("Unable to start child: " + vmse.getMessage() + '\n');
            ChildSession.dumpFailedLaunchInfo(diagnostics, vmse.process());
        }
        return vm;
    }

    private boolean connectToVMProcess() {
        if (this.vm == null) {
            return false;
        }
        this.process = this.vm.process();
        this.in = new PrintWriter(new OutputStreamWriter(this.process.getOutputStream()));
        this.out = new BufferedReader(new InputStreamReader(this.process.getInputStream()), 1);
        this.err = new BufferedReader(new InputStreamReader(this.process.getErrorStream()), 1);
        return true;
    }

    private static class InputWriter
    extends Thread {
        private PrintWriter stream;
        private InputListener input;
        private boolean running = true;

        InputWriter(String threadName, PrintWriter stream, InputListener input) {
            super(threadName);
            this.stream = stream;
            this.input = input;
        }

        public void quit() {
            this.running = false;
        }

        public void run() {
            while (this.running) {
                String line = this.input.getLine();
                this.stream.println(line);
                this.stream.flush();
            }
        }
    }

    private static class OutputReader
    extends Thread {
        private String streamName;
        private BufferedReader stream;
        private OutputListener output;
        private OutputListener diagnostics;
        private boolean running = true;
        private char[] buffer = new char[512];

        OutputReader(String threadName, String streamName, BufferedReader stream, OutputListener output, OutputListener diagnostics) {
            super(threadName);
            this.streamName = streamName;
            this.stream = stream;
            this.output = output;
            this.diagnostics = diagnostics;
        }

        public void quit() {
            this.running = false;
        }

        public void run() {
            try {
                int count;
                while (this.running && (count = this.stream.read(this.buffer, 0, 512)) != -1) {
                    if (count <= 0) continue;
                    final String chars = new String(this.buffer, 0, count);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            OutputReader.this.output.putString(chars);
                        }
                    });
                }
            }
            catch (IOException e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        OutputReader.this.diagnostics.putString("IO error reading " + OutputReader.this.streamName + " stream of child java interpreter");
                    }
                });
            }
        }
    }
}

