/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.example.debug.bdi;

import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import com.sun.tools.example.debug.bdi.EventRequestSpecList;
import com.sun.tools.example.debug.bdi.ReferenceTypeSpec;
import com.sun.tools.example.debug.bdi.WatchpointSpec;

public class AccessWatchpointSpec
extends WatchpointSpec {
    AccessWatchpointSpec(EventRequestSpecList specs, ReferenceTypeSpec refSpec, String fieldId) {
        super(specs, refSpec, fieldId);
    }

    void resolve(ReferenceType refType) throws InvalidTypeException, NoSuchFieldException {
        if (!(refType instanceof ClassType)) {
            throw new InvalidTypeException();
        }
        Field field = refType.fieldByName(this.fieldId);
        if (field == null) {
            throw new NoSuchFieldException(this.fieldId);
        }
        this.setRequest(refType.virtualMachine().eventRequestManager().createAccessWatchpointRequest(field));
    }

    public boolean equals(Object obj) {
        return obj instanceof AccessWatchpointSpec && super.equals(obj);
    }
}

