/*
 * Decompiled with CFR 0.152.
 */
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JDBCAdapter
extends AbstractTableModel {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    String[] columnNames = new String[0];
    Vector rows = new Vector();
    ResultSetMetaData metaData;

    public JDBCAdapter(String url, String driverName, String user, String passwd) {
        try {
            Class.forName(driverName);
            System.out.println("Opening db connection");
            this.connection = DriverManager.getConnection(url, user, passwd);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException ex) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(ex);
        }
        catch (SQLException ex) {
            System.err.println("Cannot connect to this database.");
            System.err.println(ex);
        }
    }

    public void executeQuery(String query) {
        if (this.connection == null || this.statement == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.resultSet = this.statement.executeQuery(query);
            this.metaData = this.resultSet.getMetaData();
            int numberOfColumns = this.metaData.getColumnCount();
            this.columnNames = new String[numberOfColumns];
            for (int column = 0; column < numberOfColumns; ++column) {
                this.columnNames[column] = this.metaData.getColumnLabel(column + 1);
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Object> newRow = new Vector<Object>();
                for (int i = 1; i <= this.getColumnCount(); ++i) {
                    newRow.addElement(this.resultSet.getObject(i));
                }
                this.rows.addElement(newRow);
            }
            this.fireTableChanged(null);
        }
        catch (SQLException ex) {
            System.err.println(ex);
        }
    }

    public void close() throws SQLException {
        System.out.println("Closing db connection");
        this.resultSet.close();
        this.statement.close();
        this.connection.close();
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String getColumnName(int column) {
        if (this.columnNames[column] != null) {
            return this.columnNames[column];
        }
        return "";
    }

    public Class getColumnClass(int column) {
        int type;
        try {
            type = this.metaData.getColumnType(column + 1);
        }
        catch (SQLException e) {
            return super.getColumnClass(column);
        }
        switch (type) {
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case -7: {
                return Boolean.class;
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.class;
            }
            case -5: {
                return Long.class;
            }
            case 6: 
            case 8: {
                return Double.class;
            }
            case 91: {
                return Date.class;
            }
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        try {
            return this.metaData.isWritable(column + 1);
        }
        catch (SQLException e) {
            return false;
        }
    }

    public int getColumnCount() {
        return this.columnNames.length;
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public Object getValueAt(int aRow, int aColumn) {
        Vector row = (Vector)this.rows.elementAt(aRow);
        return row.elementAt(aColumn);
    }

    public String dbRepresentation(int column, Object value) {
        int type;
        if (value == null) {
            return "null";
        }
        try {
            type = this.metaData.getColumnType(column + 1);
        }
        catch (SQLException e) {
            return value.toString();
        }
        switch (type) {
            case 4: 
            case 6: 
            case 8: {
                return value.toString();
            }
            case -7: {
                return (Boolean)value != false ? "1" : "0";
            }
            case 91: {
                return value.toString();
            }
        }
        return "\"" + value.toString() + "\"";
    }

    public void setValueAt(Object value, int row, int column) {
        try {
            String tableName = this.metaData.getTableName(column + 1);
            if (tableName == null) {
                System.out.println("Table name returned null.");
            }
            String columnName = this.getColumnName(column);
            String query = "update " + tableName + " set " + columnName + " = " + this.dbRepresentation(column, value) + " where ";
            for (int col = 0; col < this.getColumnCount(); ++col) {
                String colName = this.getColumnName(col);
                if (colName.equals("")) continue;
                if (col != 0) {
                    query = query + " and ";
                }
                query = query + colName + " = " + this.dbRepresentation(col, this.getValueAt(row, col));
            }
            System.out.println(query);
            System.out.println("Not sending update to database");
        }
        catch (SQLException e) {
            System.err.println("Update failed");
        }
        Vector dataRow = (Vector)this.rows.elementAt(row);
        dataRow.setElementAt(value, column);
    }
}

