/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.File;
import java.text.AttributedString;
import java.util.EnumSet;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JWindow;

public final class FontPanel
extends JPanel
implements AdjustmentListener {
    private final String[] STYLES = new String[]{"plain", "bold", "italic", "bold italic"};
    private final int NONE = 0;
    private final int SCALE = 1;
    private final int SHEAR = 2;
    private final int ROTATE = 3;
    private final String[] TRANSFORMS = new String[]{"with no transforms", "with scaling", "with Shearing", "with rotation"};
    private final int DRAW_STRING = 0;
    private final int DRAW_CHARS = 1;
    private final int DRAW_BYTES = 2;
    private final int DRAW_GLYPHV = 3;
    private final int TL_DRAW = 4;
    private final int GV_OUTLINE = 5;
    private final int TL_OUTLINE = 6;
    private final String[] METHODS = new String[]{"drawString", "drawChars", "drawBytes", "drawGlyphVector", "TextLayout.draw", "GlyphVector.getOutline", "TextLayout.getOutline"};
    public final int RANGE_TEXT = 0;
    public final int ALL_GLYPHS = 1;
    public final int USER_TEXT = 2;
    public final int FILE_TEXT = 3;
    private final String[] MS_OPENING = new String[]{" Unicode ", " Glyph Code ", " lines ", " lines "};
    private final String[] MS_CLOSING = new String[]{"", "", " of User Text ", " of LineBreakMeasurer-reformatted Text "};
    private final JScrollBar verticalBar;
    private final FontCanvas fc;
    private boolean updateBackBuffer = true;
    private boolean updateFontMetrics = true;
    private boolean updateFont = true;
    private boolean force16Cols = false;
    public boolean showingError = false;
    private int g2Transform = 0;
    public final int ONE_PAGE = 0;
    public final int CUR_RANGE = 1;
    public final int ALL_TEXT = 2;
    private int printMode = 0;
    private PageFormat page = null;
    private PrinterJob printer = null;
    private String fontName = "Dialog";
    private float fontSize = 12.0f;
    private int fontStyle = 0;
    private int fontTransform = 0;
    private Font testFont = null;
    private Object antiAliasType = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
    private Object fractionalMetricsType = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
    private Object lcdContrast = FontPanel.getDefaultLCDContrast();
    private int drawMethod = 0;
    private int textToUse = 0;
    private String[] userText = null;
    private String[] fileText = null;
    private int[] drawRange = new int[]{0, 127};
    private String[] fontInfos = new String[2];
    private boolean showGrid = true;
    private final Font2DTest f2dt;
    private final JFrame parent;
    private static Integer defaultContrast;

    public FontPanel(Font2DTest demo, JFrame f) {
        this.f2dt = demo;
        this.parent = f;
        this.verticalBar = new JScrollBar(1);
        this.fc = new FontCanvas();
        this.setLayout(new BorderLayout());
        this.add("Center", this.fc);
        this.add("East", this.verticalBar);
        this.verticalBar.addAdjustmentListener(this);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                FontPanel.this.updateBackBuffer = true;
                FontPanel.this.updateFontMetrics = true;
            }
        });
        this.testFont = new Font(this.fontName, this.fontStyle, (int)this.fontSize);
        if ((float)((int)this.fontSize) != this.fontSize) {
            this.testFont = this.testFont.deriveFont(this.fontSize);
        }
        this.updateFontInfo();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    public void setTransformG2(int transform) {
        this.g2Transform = transform;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    private AffineTransform getAffineTransform(int transform) {
        AffineTransform at = new AffineTransform();
        switch (transform) {
            case 1: {
                at.setToScale(1.5, 1.5);
                break;
            }
            case 3: {
                at.setToRotation(0.5235987755982988);
                break;
            }
            case 2: {
                at.setToShear(0.4f, 0.0);
                break;
            }
            case 0: {
                break;
            }
        }
        return at;
    }

    public void setFontParams(Object obj, float size, int style, int transform) {
        this.setFontParams((String)obj, size, style, transform);
    }

    public void setFontParams(String name, float size, int style, int transform) {
        boolean fontModified = false;
        if (!name.equals(this.fontName) || style != this.fontStyle) {
            fontModified = true;
        }
        this.fontName = name;
        this.fontSize = size;
        this.fontStyle = style;
        this.fontTransform = transform;
        this.testFont = new Font(this.fontName, this.fontStyle, (int)this.fontSize);
        if ((float)((int)this.fontSize) != this.fontSize) {
            this.testFont = this.testFont.deriveFont(this.fontSize);
        }
        if (this.fontTransform != 0) {
            AffineTransform at = this.getAffineTransform(this.fontTransform);
            this.testFont = this.testFont.deriveFont(at);
        }
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
        if (fontModified) {
            this.updateFontInfo();
            this.f2dt.fireUpdateFontInfo();
        }
    }

    public void setRenderingHints(Object aa, Object fm, Object contrast) {
        this.antiAliasType = ((AAValues)((Object)aa)).getHint();
        this.fractionalMetricsType = ((FMValues)((Object)fm)).getHint();
        this.lcdContrast = contrast;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void setDrawMethod(int i) {
        this.drawMethod = i;
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void setTextToDraw(int i, int[] range, String[] textSet, String[] fileData) {
        this.textToUse = i;
        if (this.textToUse == 0) {
            this.drawRange = range;
        } else if (this.textToUse == 1) {
            this.drawMethod = 3;
        } else if (this.textToUse == 2) {
            this.userText = textSet;
        } else if (this.textToUse == 3) {
            this.fileText = fileData;
            this.drawMethod = 4;
        }
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
        this.updateFontInfo();
    }

    public void setGridDisplay(boolean b) {
        this.showGrid = b;
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void setForce16Columns(boolean b) {
        this.force16Cols = b;
        this.updateBackBuffer = true;
        this.updateFontMetrics = true;
        this.fc.repaint();
    }

    public void doPrint(int i) {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.printMode = i;
        this.printer.setPrintable(this.fc, this.page);
        if (this.printer.printDialog()) {
            try {
                this.printer.print();
            }
            catch (Exception e) {
                this.f2dt.fireChangeStatus("ERROR: Printing Failed; See Stack Trace", true);
            }
        }
    }

    public void doPageSetup() {
        if (this.printer == null) {
            this.printer = PrinterJob.getPrinterJob();
            this.page = this.printer.defaultPage();
        }
        this.page = this.printer.pageDialog(this.page);
    }

    private void updateFontInfo() {
        int numGlyphs = 0;
        int numCharsInRange = this.drawRange[1] - this.drawRange[0] + 1;
        this.fontInfos[0] = "Font Face Name: " + this.testFont.getFontName();
        this.fontInfos[1] = "Glyphs in This Range: ";
        if (this.textToUse == 0) {
            for (int i = this.drawRange[0]; i < this.drawRange[1]; ++i) {
                if (!this.testFont.canDisplay(i)) continue;
                ++numGlyphs;
            }
            this.fontInfos[1] = this.fontInfos[1] + numGlyphs + " / " + numCharsInRange;
        } else {
            this.fontInfos[1] = null;
        }
    }

    public String[] getFontInfo() {
        return this.fontInfos;
    }

    public String getCurrentOptions() {
        boolean userTextSize = false;
        String options = this.fontName + "\n" + this.fontSize + "\n" + this.fontStyle + "\n" + this.fontTransform + "\n" + this.g2Transform + "\n" + this.textToUse + "\n" + this.drawMethod + "\n" + AAValues.getHintVal(this.antiAliasType) + "\n" + FMValues.getHintVal(this.fractionalMetricsType) + "\n" + this.lcdContrast + "\n";
        if (this.textToUse == 2) {
            for (int i = 0; i < this.userText.length; ++i) {
                options = options + this.userText[i] + "\n";
            }
        }
        return options;
    }

    public void loadOptions(boolean grid, boolean force16, int start, int end, String name, float size, int style, int transform, int g2transform, int text, int method, int aa, int fm, int contrast, String[] user) {
        int[] range = new int[]{start, end};
        this.setGridDisplay(grid);
        this.setForce16Columns(force16);
        if (this.textToUse != 3) {
            this.setTextToDraw(text, range, user, null);
        }
        this.setFontParams(name, size, style, transform);
        this.setTransformG2(g2transform);
        this.setDrawMethod(method);
        this.setRenderingHints(AAValues.getValue(aa), FMValues.getValue(fm), new Integer(contrast));
    }

    public void doSavePNG(String fileName) {
        this.fc.writePNG(fileName);
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.updateBackBuffer = true;
        this.fc.repaint();
    }

    public void paintComponent(Graphics g) {
        this.fc.repaint();
    }

    static Integer getDefaultLCDContrast() {
        if (defaultContrast == null) {
            GraphicsConfiguration gc = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
            Graphics2D g2d = (Graphics2D)gc.createCompatibleImage(1, 1).getGraphics();
            defaultContrast = (Integer)g2d.getRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST);
        }
        return defaultContrast;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AAValues {
        AADEFAULT("DEFAULT", RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT),
        AAOFF("OFF", RenderingHints.VALUE_TEXT_ANTIALIAS_OFF),
        AAON("ON", RenderingHints.VALUE_TEXT_ANTIALIAS_ON),
        AAGASP("GASP", RenderingHints.VALUE_TEXT_ANTIALIAS_GASP),
        AALCDHRGB("LCD_HRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB),
        AALCDHBGR("LCD_HBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HBGR),
        AALCDVRGB("LCD_VRGB", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VRGB),
        AALCDVBGR("LCD_VBGR", RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_VBGR);

        private String name;
        private Object hint;
        private static AAValues[] valArray;

        private AAValues(String s, Object o) {
            this.name = s;
            this.hint = o;
        }

        public String toString() {
            return this.name;
        }

        public Object getHint() {
            return this.hint;
        }

        public static boolean isLCDMode(Object o) {
            return o instanceof AAValues && ((AAValues)((Object)o)).ordinal() >= AALCDHRGB.ordinal();
        }

        public static Object getValue(int ordinal) {
            if (valArray == null) {
                valArray = EnumSet.allOf(AAValues.class).toArray(new AAValues[0]);
            }
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].ordinal() != ordinal) continue;
                return valArray[i];
            }
            return valArray[0];
        }

        private static AAValues[] getArray() {
            if (valArray == null) {
                AAValues[] oa = EnumSet.allOf(AAValues.class).toArray(new AAValues[0]);
                valArray = EnumSet.allOf(AAValues.class).toArray(new AAValues[0]);
            }
            return valArray;
        }

        public static int getHintVal(Object hint) {
            AAValues.getArray();
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].getHint() != hint) continue;
                return i;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FMValues {
        FMDEFAULT("DEFAULT", RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT),
        FMOFF("OFF", RenderingHints.VALUE_FRACTIONALMETRICS_OFF),
        FMON("ON", RenderingHints.VALUE_FRACTIONALMETRICS_ON);

        private String name;
        private Object hint;
        private static FMValues[] valArray;

        private FMValues(String s, Object o) {
            this.name = s;
            this.hint = o;
        }

        public String toString() {
            return this.name;
        }

        public Object getHint() {
            return this.hint;
        }

        public static Object getValue(int ordinal) {
            if (valArray == null) {
                valArray = EnumSet.allOf(FMValues.class).toArray(new FMValues[0]);
            }
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].ordinal() != ordinal) continue;
                return valArray[i];
            }
            return valArray[0];
        }

        private static FMValues[] getArray() {
            if (valArray == null) {
                valArray = EnumSet.allOf(FMValues.class).toArray(new FMValues[0]);
            }
            return valArray;
        }

        public static int getHintVal(Object hint) {
            FMValues.getArray();
            for (int i = 0; i < valArray.length; ++i) {
                if (valArray[i].getHint() != hint) continue;
                return i;
            }
            return 0;
        }
    }

    private final class CannotDrawException
    extends RuntimeException {
        public final int id;

        public CannotDrawException(int i) {
            this.id = i;
        }
    }

    private class FontCanvas
    extends JPanel
    implements MouseListener,
    MouseMotionListener,
    Printable {
        private int numCharAcross;
        private int numCharDown;
        private int drawStart;
        private int drawEnd;
        private int drawLimit;
        private int maxAscent;
        private int maxDescent;
        private int gridWidth = 0;
        private int gridHeight = 0;
        private int canvasInset_X = 5;
        private int canvasInset_Y = 5;
        private BufferedImage backBuffer = null;
        private Vector lineBreakTLs = null;
        private boolean isPrinting = false;
        private int lastPage;
        private int printPageNumber;
        private int currentlyShownChar = 0;
        private final int PR_OFFSET = 10;
        private final int PR_TITLE_LINEHEIGHT = 30;
        private final JWindow zoomWindow;
        private BufferedImage zoomImage = null;
        private int mouseOverCharX = -1;
        private int mouseOverCharY = -1;
        private int currMouseOverChar = -1;
        private int prevZoomChar = -1;
        private float ZOOM = 2.0f;
        private boolean nowZooming = false;
        private boolean firstTime = true;
        private String backupStatusString = null;
        private final String[] ERRORS = new String[]{"ERROR: drawBytes cannot handle characters beyond 0x00FF. Select different range or draw methods.", "ERROR: Cannot fit text with the current font size. Resize the window or use smaller font size.", "ERROR: Cannot print with the current font size. Use smaller font size."};
        private final int DRAW_BYTES_ERROR = 0;
        private final int CANT_FIT_DRAW = 1;
        private final int CANT_FIT_PRINT = 2;
        private final Cursor blankCursor;

        public FontCanvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setForeground(Color.black);
            this.setBackground(Color.white);
            Toolkit tk = Toolkit.getDefaultToolkit();
            byte[] bogus = new byte[]{0};
            this.blankCursor = tk.createCustomCursor(tk.createImage(bogus), new Point(0, 0), "");
            this.zoomWindow = new JWindow(FontPanel.this.parent){

                public void paint(Graphics g) {
                    g.drawImage(FontCanvas.this.zoomImage, 0, 0, FontCanvas.this.zoomWindow);
                }
            };
            this.zoomWindow.setCursor(this.blankCursor);
            this.zoomWindow.pack();
        }

        public boolean firstTime() {
            return this.firstTime;
        }

        public void refresh() {
            this.firstTime = false;
            FontPanel.this.updateBackBuffer = true;
            this.repaint();
        }

        private void setParams(Graphics2D g2) {
            g2.setFont(FontPanel.this.testFont);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, FontPanel.this.antiAliasType);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, FontPanel.this.fractionalMetricsType);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, FontPanel.this.lcdContrast);
            if (FontPanel.this.antiAliasType == RenderingHints.VALUE_TEXT_ANTIALIAS_ON && (FontPanel.this.drawMethod == 6 || FontPanel.this.drawMethod == 5)) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            } else {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }

        private void drawGrid(Graphics2D g2) {
            int i;
            int totalGridWidth = this.numCharAcross * this.gridWidth;
            int totalGridHeight = this.numCharDown * this.gridHeight;
            g2.setColor(Color.black);
            for (i = 0; i < this.numCharDown + 1; ++i) {
                g2.drawLine(this.canvasInset_X, i * this.gridHeight + this.canvasInset_Y, this.canvasInset_X + totalGridWidth, i * this.gridHeight + this.canvasInset_Y);
            }
            for (i = 0; i < this.numCharAcross + 1; ++i) {
                g2.drawLine(i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y, i * this.gridWidth + this.canvasInset_X, this.canvasInset_Y + totalGridHeight);
            }
        }

        public void modeSpecificDrawChar(Graphics2D g2, int charCode, int baseX, int baseY) {
            int[] oneGlyph = new int[]{charCode};
            char[] charArray = Character.toChars(charCode);
            FontRenderContext frc = g2.getFontRenderContext();
            AffineTransform oldTX = g2.getTransform();
            GlyphVector gv = FontPanel.this.textToUse == 1 ? FontPanel.this.testFont.createGlyphVector(frc, oneGlyph) : FontPanel.this.testFont.createGlyphVector(frc, charArray);
            Rectangle2D r2d2 = gv.getPixelBounds(frc, 0.0f, 0.0f);
            int shiftedX = baseX;
            try {
                double[] pt = new double[]{r2d2.getX(), r2d2.getY(), r2d2.getX() + r2d2.getWidth(), r2d2.getY() + r2d2.getHeight()};
                oldTX.inverseTransform(pt, 0, pt, 0, 2);
                shiftedX = baseX - (int)(pt[2] / 2.0 + pt[0]);
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
            g2.translate(shiftedX, baseY);
            g2.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            if (FontPanel.this.textToUse == 1) {
                g2.drawGlyphVector(gv, 0.0f, 0.0f);
            } else {
                if (FontPanel.this.testFont.canDisplay(charCode)) {
                    g2.setColor(Color.black);
                } else {
                    g2.setColor(Color.lightGray);
                }
                switch (FontPanel.this.drawMethod) {
                    case 0: {
                        g2.drawString(new String(charArray), 0, 0);
                        break;
                    }
                    case 1: {
                        g2.drawChars(charArray, 0, 1, 0, 0);
                        break;
                    }
                    case 2: {
                        if (charCode > 255) {
                            throw new CannotDrawException(0);
                        }
                        byte[] oneByte = new byte[]{(byte)charCode};
                        g2.drawBytes(oneByte, 0, 1, 0, 0);
                        break;
                    }
                    case 3: {
                        g2.drawGlyphVector(gv, 0.0f, 0.0f);
                        break;
                    }
                    case 4: {
                        TextLayout tl = new TextLayout(new String(charArray), FontPanel.this.testFont, frc);
                        tl.draw(g2, 0.0f, 0.0f);
                        break;
                    }
                    case 5: {
                        r2d2 = gv.getVisualBounds();
                        shiftedX = baseX - (int)(r2d2.getWidth() / 2.0 + r2d2.getX());
                        g2.draw(gv.getOutline(0.0f, 0.0f));
                        break;
                    }
                    case 6: {
                        r2d2 = gv.getVisualBounds();
                        shiftedX = baseX - (int)(r2d2.getWidth() / 2.0 + r2d2.getX());
                        TextLayout tlo = new TextLayout(new String(charArray), FontPanel.this.testFont, g2.getFontRenderContext());
                        g2.draw(tlo.getOutline(null));
                    }
                }
            }
            g2.setTransform(oldTX);
        }

        private void modeSpecificDrawLine(Graphics2D g2, String line, int baseX, int baseY) {
            AffineTransform oldTx = null;
            oldTx = g2.getTransform();
            g2.translate(baseX, baseY);
            g2.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            switch (FontPanel.this.drawMethod) {
                case 0: {
                    g2.drawString(line, 0, 0);
                    break;
                }
                case 1: {
                    g2.drawChars(line.toCharArray(), 0, line.length(), 0, 0);
                    break;
                }
                case 2: {
                    try {
                        byte[] lineBytes = line.getBytes("ISO-8859-1");
                        g2.drawBytes(lineBytes, 0, lineBytes.length, 0, 0);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break;
                }
                case 3: {
                    GlyphVector gv = FontPanel.this.testFont.createGlyphVector(g2.getFontRenderContext(), line);
                    g2.drawGlyphVector(gv, 0.0f, 0.0f);
                    break;
                }
                case 4: {
                    TextLayout tl = new TextLayout(line, FontPanel.this.testFont, g2.getFontRenderContext());
                    tl.draw(g2, 0.0f, 0.0f);
                    break;
                }
                case 5: {
                    GlyphVector gvo = FontPanel.this.testFont.createGlyphVector(g2.getFontRenderContext(), line);
                    g2.draw(gvo.getOutline(0.0f, 0.0f));
                    break;
                }
                case 6: {
                    TextLayout tlo = new TextLayout(line, FontPanel.this.testFont, g2.getFontRenderContext());
                    AffineTransform at = new AffineTransform();
                    g2.draw(tlo.getOutline(at));
                }
            }
            g2.setTransform(oldTx);
        }

        private void tlDrawLine(Graphics2D g2, TextLayout tl, float baseX, float baseY) {
            AffineTransform oldTx = null;
            oldTx = g2.getTransform();
            g2.translate(baseX, baseY);
            g2.transform(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform));
            tl.draw(g2, 0.0f, 0.0f);
            g2.setTransform(oldTx);
        }

        private String modeSpecificNumStr(int i) {
            if (FontPanel.this.textToUse == 2 || FontPanel.this.textToUse == 3) {
                return String.valueOf(i + 1);
            }
            StringBuffer s = new StringBuffer(Integer.toHexString(i));
            while (s.length() < 4) {
                s.insert(0, "0");
            }
            return s.toString().toUpperCase();
        }

        private void resetScrollbar(int oldValue) {
            int totalNumRows = 1;
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                int numCharToDisplay = FontPanel.this.textToUse == 0 ? FontPanel.this.drawRange[1] - FontPanel.this.drawRange[0] : FontPanel.this.testFont.getNumGlyphs();
                totalNumRows = numCharToDisplay / this.numCharAcross;
                if (numCharToDisplay % this.numCharAcross != 0) {
                    ++totalNumRows;
                }
                if (oldValue / this.numCharAcross > totalNumRows) {
                    oldValue = 0;
                }
                FontPanel.this.verticalBar.setValues(oldValue / this.numCharAcross, this.numCharDown, 0, totalNumRows);
            } else {
                totalNumRows = FontPanel.this.textToUse == 2 ? FontPanel.this.userText.length : this.lineBreakTLs.size();
                FontPanel.this.verticalBar.setValues(oldValue, this.numCharDown, 0, totalNumRows);
            }
            if (totalNumRows <= this.numCharDown && this.drawStart == 0) {
                FontPanel.this.verticalBar.setEnabled(false);
            } else {
                FontPanel.this.verticalBar.setEnabled(true);
            }
        }

        private void calcFontMetrics(Graphics2D g2d, int w, int h) {
            FontMetrics fm;
            Graphics2D g2 = (Graphics2D)g2d.create();
            if (FontPanel.this.g2Transform != 0 && FontPanel.this.textToUse != 3) {
                g2.setFont(g2.getFont().deriveFont(FontPanel.this.getAffineTransform(FontPanel.this.g2Transform)));
                fm = g2.getFontMetrics();
            } else {
                fm = g2.getFontMetrics();
            }
            this.maxAscent = fm.getMaxAscent();
            this.maxDescent = fm.getMaxDescent();
            if (this.maxAscent == 0) {
                this.maxAscent = 10;
            }
            if (this.maxDescent == 0) {
                this.maxDescent = 5;
            }
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                this.maxAscent += 3;
                this.maxDescent += 3;
                this.gridWidth = fm.getMaxAdvance() + 6;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharAcross = FontPanel.this.force16Cols ? 16 : (w - 10) / this.gridWidth;
                this.numCharDown = (h - 10) / this.gridHeight;
                this.canvasInset_X = (w - this.numCharAcross * this.gridWidth) / 2;
                this.canvasInset_Y = (h - this.numCharDown * this.gridHeight) / 2;
                if (this.numCharDown == 0 || this.numCharAcross == 0) {
                    throw new CannotDrawException(this.isPrinting ? 2 : 1);
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(FontPanel.this.verticalBar.getValue() * this.numCharAcross);
                }
            } else {
                this.maxDescent += fm.getLeading();
                this.canvasInset_X = 5;
                this.canvasInset_Y = 5;
                this.gridHeight = this.maxAscent + this.maxDescent;
                this.numCharDown = (h - this.canvasInset_Y * 2) / this.gridHeight;
                if (this.numCharDown == 0) {
                    throw new CannotDrawException(this.isPrinting ? 2 : 1);
                }
                if (FontPanel.this.textToUse == 3) {
                    if (!this.isPrinting) {
                        FontPanel.this.f2dt.fireChangeStatus("LineBreaking Text... Please Wait", false);
                    }
                    this.lineBreakTLs = new Vector();
                    for (int i = 0; i < FontPanel.this.fileText.length; ++i) {
                        AttributedString as = new AttributedString(FontPanel.this.fileText[i], g2.getFont().getAttributes());
                        LineBreakMeasurer lbm = new LineBreakMeasurer(as.getIterator(), g2.getFontRenderContext());
                        while (lbm.getPosition() < FontPanel.this.fileText[i].length()) {
                            this.lineBreakTLs.add(lbm.nextLayout(w));
                        }
                    }
                }
                if (!this.isPrinting) {
                    this.resetScrollbar(FontPanel.this.verticalBar.getValue());
                }
            }
        }

        private void calcTextRange() {
            Object displaying = null;
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                this.drawStart = this.isPrinting ? (FontPanel.this.printMode == 0 ? this.currentlyShownChar : this.numCharAcross * this.numCharDown * this.printPageNumber) : FontPanel.this.verticalBar.getValue() * this.numCharAcross;
                if (FontPanel.this.textToUse == 0) {
                    this.drawStart += FontPanel.this.drawRange[0];
                    this.drawLimit = FontPanel.this.drawRange[1];
                } else {
                    this.drawLimit = FontPanel.this.testFont.getNumGlyphs();
                }
                this.drawEnd = this.drawStart + this.numCharAcross * this.numCharDown - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            } else {
                this.drawStart = this.isPrinting ? (FontPanel.this.printMode == 0 ? this.currentlyShownChar : this.numCharDown * this.printPageNumber) : FontPanel.this.verticalBar.getValue();
                this.drawEnd = this.drawStart + this.numCharDown - 1;
                this.drawLimit = FontPanel.this.textToUse == 2 ? FontPanel.this.userText.length - 1 : this.lineBreakTLs.size() - 1;
                if (this.drawEnd >= this.drawLimit) {
                    this.drawEnd = this.drawLimit;
                }
            }
            if (this.drawStart > this.drawEnd) {
                this.drawStart = 0;
                FontPanel.this.verticalBar.setValue(this.drawStart);
            }
            if (!this.isPrinting) {
                this.backupStatusString = "Displaying" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + FontPanel.this.MS_CLOSING[FontPanel.this.textToUse];
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        private void drawText(Graphics g, int w, int h) {
            Graphics2D g2;
            if (this.isPrinting) {
                g2 = (Graphics2D)g;
            } else {
                this.backBuffer = (BufferedImage)this.createImage(w, h);
                g2 = this.backBuffer.createGraphics();
                g2.setColor(Color.white);
                g2.fillRect(0, 0, w, h);
                g2.setColor(Color.black);
            }
            this.setParams(g2);
            if (FontPanel.this.updateFontMetrics || this.isPrinting) {
                this.calcFontMetrics(g2, w, h);
                FontPanel.this.updateFontMetrics = false;
            }
            this.calcTextRange();
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                int charToDraw = this.drawStart;
                if (FontPanel.this.showGrid) {
                    this.drawGrid(g2);
                }
                if (!this.isPrinting) {
                    g.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = 0; i < this.numCharDown && charToDraw <= this.drawEnd; ++i) {
                    for (int j = 0; j < this.numCharAcross && charToDraw <= this.drawEnd; ++j, ++charToDraw) {
                        int gridLocX = j * this.gridWidth + this.canvasInset_X;
                        int gridLocY = i * this.gridHeight + this.canvasInset_Y;
                        this.modeSpecificDrawChar(g2, charToDraw, gridLocX + this.gridWidth / 2, gridLocY + this.maxAscent);
                    }
                }
            } else if (FontPanel.this.textToUse == 2) {
                g2.drawRect(0, 0, w - 1, h - 1);
                if (!this.isPrinting) {
                    g.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    int lineStartX = this.canvasInset_Y;
                    int lineStartY = (i - this.drawStart) * this.gridHeight + this.maxAscent;
                    this.modeSpecificDrawLine(g2, FontPanel.this.userText[i], lineStartX, lineStartY);
                }
            } else {
                float yPos = this.canvasInset_Y;
                g2.drawRect(0, 0, w - 1, h - 1);
                if (!this.isPrinting) {
                    g.drawImage(this.backBuffer, 0, 0, this);
                }
                for (int i = this.drawStart; i <= this.drawEnd; ++i) {
                    TextLayout oneLine = (TextLayout)this.lineBreakTLs.elementAt(i);
                    float xPos = oneLine.isLeftToRight() ? (float)this.canvasInset_X : (float)w - oneLine.getAdvance() - (float)this.canvasInset_X;
                    float[] fmData = new float[]{0.0f, oneLine.getAscent(), 0.0f, oneLine.getDescent(), 0.0f, oneLine.getLeading()};
                    if (FontPanel.this.g2Transform != 0) {
                        AffineTransform at = FontPanel.this.getAffineTransform(FontPanel.this.g2Transform);
                        at.transform(fmData, 0, fmData, 0, 3);
                    }
                    this.tlDrawLine(g2, oneLine, xPos, yPos += fmData[1]);
                    yPos += fmData[3] + fmData[5];
                }
            }
            if (!this.isPrinting) {
                g.drawImage(this.backBuffer, 0, 0, this);
            }
            g2.dispose();
        }

        public void paintComponent(Graphics g) {
            if (FontPanel.this.updateBackBuffer) {
                Dimension d = this.getSize();
                this.isPrinting = false;
                try {
                    this.drawText(g, d.width, d.height);
                }
                catch (CannotDrawException e) {
                    FontPanel.this.f2dt.fireChangeStatus(this.ERRORS[e.id], true);
                    super.paintComponent(g);
                    return;
                }
            } else {
                g.drawImage(this.backBuffer, 0, 0, this);
            }
            FontPanel.this.showingError = false;
            FontPanel.this.updateBackBuffer = false;
        }

        public int print(Graphics g, PageFormat pf, int pageIndex) {
            if (pageIndex == 0) {
                this.lastPage = Integer.MAX_VALUE;
                this.currentlyShownChar = FontPanel.this.verticalBar.getValue() * this.numCharAcross;
            }
            if (FontPanel.this.printMode == 0 ? pageIndex > 0 : pageIndex > this.lastPage) {
                return 1;
            }
            int pageWidth = (int)pf.getImageableWidth();
            int pageHeight = (int)pf.getImageableHeight();
            int backupDrawStart = this.drawStart;
            int backupDrawEnd = this.drawEnd;
            int backupNumCharAcross = this.numCharAcross;
            int backupNumCharDown = this.numCharDown;
            Vector backupLineBreakTLs = null;
            if (FontPanel.this.textToUse == 3) {
                backupLineBreakTLs = (Vector)this.lineBreakTLs.clone();
            }
            this.printPageNumber = pageIndex;
            this.isPrinting = true;
            g.translate((int)pf.getImageableX(), (int)pf.getImageableY() + 60);
            try {
                this.drawText(g, pageWidth, pageHeight - 60);
            }
            catch (CannotDrawException e) {
                FontPanel.this.f2dt.fireChangeStatus(this.ERRORS[e.id], true);
                return 1;
            }
            String hints = " with antialias " + FontPanel.this.antiAliasType + "and" + " fractional metrics " + FontPanel.this.fractionalMetricsType + " and lcd contrast = " + FontPanel.this.lcdContrast;
            String infoLine1 = "Printing" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(this.drawStart) + " to " + this.modeSpecificNumStr(this.drawEnd) + FontPanel.this.MS_CLOSING[FontPanel.this.textToUse];
            String infoLine2 = "With " + FontPanel.this.fontName + " " + FontPanel.this.STYLES[FontPanel.this.fontStyle] + " at " + FontPanel.this.fontSize + " point size " + FontPanel.this.TRANSFORMS[FontPanel.this.fontTransform];
            String infoLine3 = "Using " + FontPanel.this.METHODS[FontPanel.this.drawMethod] + hints;
            String infoLine4 = "Page: " + (pageIndex + 1);
            g.setFont(new Font("dialog", 0, 12));
            g.setColor(Color.black);
            g.translate(0, -60);
            g.drawString(infoLine1, 15, 10);
            g.drawString(infoLine2, 15, 22);
            g.drawString(infoLine3, 15, 34);
            g.drawString(infoLine4, 15, 46);
            if (this.drawEnd == this.drawLimit) {
                this.lastPage = pageIndex;
            }
            this.drawStart = backupDrawStart;
            this.drawEnd = backupDrawEnd;
            this.numCharAcross = backupNumCharAcross;
            this.numCharDown = backupNumCharDown;
            if (FontPanel.this.textToUse == 3) {
                this.lineBreakTLs = backupLineBreakTLs;
            }
            return 0;
        }

        public void writePNG(String fileName) {
            try {
                ImageIO.write((RenderedImage)this.backBuffer, "png", new File(fileName));
            }
            catch (Exception e) {
                FontPanel.this.f2dt.fireChangeStatus("ERROR: Failed to Save PNG image; See stack trace", true);
                e.printStackTrace();
            }
        }

        private boolean checkMouseLoc(MouseEvent e) {
            if (this.gridWidth != 0 && this.gridHeight != 0 && (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1)) {
                int charLocX = (e.getX() - this.canvasInset_X) / this.gridWidth;
                int charLocY = (e.getY() - this.canvasInset_Y) / this.gridHeight;
                if (charLocX >= 0 && charLocY >= 0 && charLocX < this.numCharAcross && charLocY < this.numCharDown) {
                    int mouseOverChar = charLocX + (FontPanel.this.verticalBar.getValue() + charLocY) * this.numCharAcross;
                    if (FontPanel.this.textToUse == 0) {
                        mouseOverChar += FontPanel.this.drawRange[0];
                    }
                    if (mouseOverChar > this.drawEnd) {
                        return false;
                    }
                    this.mouseOverCharX = charLocX;
                    this.mouseOverCharY = charLocY;
                    this.currMouseOverChar = mouseOverChar;
                    FontPanel.this.f2dt.fireChangeStatus("Pointing to" + FontPanel.this.MS_OPENING[FontPanel.this.textToUse] + this.modeSpecificNumStr(mouseOverChar), false);
                    return true;
                }
            }
            return false;
        }

        public void showZoomed() {
            Font backup = FontPanel.this.testFont;
            Point canvasLoc = this.getLocationOnScreen();
            int dialogOffsetX = (int)((float)this.gridWidth * (this.ZOOM - 1.0f) / 2.0f);
            int dialogOffsetY = (int)((float)this.gridHeight * (this.ZOOM - 1.0f) / 2.0f);
            int zoomAreaX = this.mouseOverCharX * this.gridWidth + this.canvasInset_X - dialogOffsetX;
            int zoomAreaY = this.mouseOverCharY * this.gridHeight + this.canvasInset_Y - dialogOffsetY;
            int zoomAreaWidth = (int)((float)this.gridWidth * this.ZOOM);
            int zoomAreaHeight = (int)((float)this.gridHeight * this.ZOOM);
            this.zoomWindow.setLocation(canvasLoc.x + zoomAreaX, canvasLoc.y + zoomAreaY);
            if (!this.nowZooming) {
                if (this.zoomWindow.getWarningString() != null) {
                    this.zoomWindow.setSize(zoomAreaWidth + 1, zoomAreaHeight + 20);
                } else {
                    this.zoomWindow.setSize(zoomAreaWidth + 1, zoomAreaHeight + 1);
                }
            }
            this.zoomImage = (BufferedImage)this.zoomWindow.createImage(zoomAreaWidth + 1, zoomAreaHeight + 1);
            Graphics2D g2 = (Graphics2D)this.zoomImage.getGraphics();
            FontPanel.this.testFont = FontPanel.this.testFont.deriveFont(FontPanel.this.fontSize * this.ZOOM);
            this.setParams(g2);
            g2.setColor(Color.white);
            g2.fillRect(0, 0, zoomAreaWidth, zoomAreaHeight);
            g2.setColor(Color.black);
            g2.drawRect(0, 0, zoomAreaWidth, zoomAreaHeight);
            this.modeSpecificDrawChar(g2, this.currMouseOverChar, zoomAreaWidth / 2, (int)((float)this.maxAscent * this.ZOOM));
            g2.dispose();
            if (!this.nowZooming) {
                this.zoomWindow.show();
            }
            this.zoomWindow.getGraphics().drawImage(this.zoomImage, 0, 0, this);
            this.nowZooming = true;
            this.prevZoomChar = this.currMouseOverChar;
            FontPanel.this.testFont = backup;
            if (this.firstTime()) {
                this.refresh();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (!FontPanel.this.showingError && this.checkMouseLoc(e)) {
                this.showZoomed();
                this.setCursor(this.blankCursor);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (FontPanel.this.textToUse == 0 || FontPanel.this.textToUse == 1) {
                if (this.nowZooming) {
                    this.zoomWindow.hide();
                }
                this.nowZooming = false;
            }
            this.setCursor(Cursor.getDefaultCursor());
        }

        public void mouseExited(MouseEvent e) {
            if (!FontPanel.this.showingError && !this.nowZooming) {
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        public void mouseMoved(MouseEvent e) {
            if (!FontPanel.this.showingError && !this.checkMouseLoc(e)) {
                FontPanel.this.f2dt.fireChangeStatus(this.backupStatusString, false);
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!FontPanel.this.showingError && this.nowZooming && this.checkMouseLoc(e) && this.currMouseOverChar != this.prevZoomChar) {
                this.showZoomed();
            }
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }
    }
}

